

<?php $__env->startSection('title', 'Transfer Funds'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-5" style="background: linear-gradient(135deg, #f0f5ff, #ffffff);">
    <!-- Page Header -->
    <div class="row justify-content-center mb-4">
        <div class="col-lg-8 text-center">
            <h1 class="fw-bold text-gradient mb-3">
                <i class="fas fa-exchange-alt me-2"></i> Transfer Funds
            </h1>
            <p class="fs-6 text-muted">
                Manage your funds effortlessly. Transfer between your wallet and MT5 account with just a few clicks.
            </p>
        </div>
    </div>

    <!-- Transfer Funds Form Section -->
    <div class="row justify-content-center">
        <div class="col-lg-6">
            <div class="card shadow border-0 rounded-4">
                <div class="card-header text-white text-center" style="background: linear-gradient(135deg, #007bff, #0056b3);">
                    <h4 class="m-0 fw-bold">
                        <i class="fas fa-wallet me-2"></i> Wallet Balance: <span class="text-warning">$<?php echo e(number_format($walletBalance, 2)); ?></span>
                    </h4>
                </div>
                <div class="card-body" style="background: linear-gradient(135deg, #ffffff, #f8f9fa);">
                    <!-- Success/Error Messages -->
                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="fas fa-check-circle me-2"></i> <?php echo e(session('success')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php elseif(session('error')): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <i class="fas fa-times-circle me-2"></i> <?php echo e(session('error')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endif; ?>

                    <!-- Transfer Funds Form -->
                    <form action="<?php echo e(route('user.transferFunds.submit')); ?>" method="POST" class="mt-4">
                        <?php echo csrf_field(); ?>
                        <!-- Amount Input -->
                        <div class="form-floating mb-4">
                            <input 
                                type="number" 
                                step="0.01" 
                                name="amount" 
                                id="amount" 
                                class="form-control shadow-sm <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                placeholder="Enter Amount" 
                                required>
                            <label for="amount">
                                <i class="fas fa-dollar-sign me-2"></i> Enter Amount
                            </label>
                            <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback">
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Action Selection -->
                        <div class="form-floating mb-4">
                            <select 
                                name="action" 
                                id="action" 
                                class="form-select shadow-sm <?php $__errorArgs = ['action'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                required>
                                <option value="deposit">Deposit to MT5</option>
                                <option value="withdraw">Withdraw from MT5</option>
                            </select>
                            <label for="action">
                                <i class="fas fa-exchange-alt me-2"></i> Select Action
                            </label>
                            <?php $__errorArgs = ['action'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback">
                                    <?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Submit Button -->
                        <div class="text-center">
                            <button type="submit" class="btn btn-primary shadow-sm px-5 py-2 rounded-pill">
                                <i class="fas fa-paper-plane me-2"></i> Submit Transfer
                            </button>
                        </div>
                    </form>
                </div>
                <div class="card-footer text-center text-muted">
                    <small>Ensure your wallet has sufficient balance before initiating a transfer.</small>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Section -->
    <div class="row mt-5 g-3">
        <div class="col-md-6">
            <div class="card shadow border-0 rounded-4">
                <div class="card-header bg-gradient ">
                    <i class="fas fa-chart-bar me-2"></i> Recent Transfer Activity
                </div>
                <div class="card-body">
                    <canvas id="recentTransfersChart"></canvas>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card shadow border-0 rounded-4">
                <div class="card-header bg-gradient ">
                    <i class="fas fa-chart-pie me-2"></i> Funds Allocation
                </div>
                <div class="card-body">
                    <canvas id="fundsAllocationChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
    .text-gradient {
        background: linear-gradient(to right, #ff7e5f, #feb47b);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
    }

    .form-control, 
    .form-select {
        border-radius: 12px;
        box-shadow: 0px 5px 15px rgba(0, 0, 0, 0.1);
    }

    .form-control:focus, 
    .form-select:focus {
        box-shadow: 0px 8px 20px rgba(0, 123, 255, 0.25);
        border-color: #007bff;
    }

    .btn-primary {
        background: linear-gradient(135deg, #007bff, #0056b3);
        border: none;
    }

    .btn-primary:hover {
        background: linear-gradient(135deg, #0056b3, #003f7f);
        color: #fff;
    }

    .card-header {
        font-size: 1.2rem;
        font-weight: bold;
    }

    .alert {
        font-size: 0.9rem;
    }

    .card-footer {
        font-size: 0.85rem;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Chart Scripts
    const ctx1 = document.getElementById('recentTransfersChart').getContext('2d');
    const ctx2 = document.getElementById('fundsAllocationChart').getContext('2d');

    new Chart(ctx1, {
        type: 'line',
        data: {
            labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
            datasets: [{
                label: 'Transfers ($)',
                data: [120, 190, 300, 250, 210, 300],
                backgroundColor: 'rgba(54, 162, 235, 0.2)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 2,
                fill: true,
            }]
        },
        options: {
            responsive: true,
        }
    });

    new Chart(ctx2, {
        type: 'doughnut',
        data: {
            labels: ['Deposits', 'Withdrawals'],
            datasets: [{
                data: [65, 35],
                backgroundColor: ['#28a745', '#ffc107'],
                hoverOffset: 4
            }]
        },
        options: {
            responsive: true,
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\user\transferFunds.blade.php ENDPATH**/ ?>