

<?php $__env->startSection('title', 'Admin Activity Logs'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <h2 class="mt-4">Activity Logs</h2>

    <?php if($logs->isNotEmpty()): ?>
        <table class="table table-hover mt-3">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>User</th>
                    <th>Action</th>
                    <th>IP Address</th>
                    <th>Created At</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td><?php echo e($log->user->name); ?></td>
                        <td><?php echo e($log->action); ?></td>
                        <td><?php echo e($log->ip_address); ?></td>
                        <td><?php echo e($log->created_at->format('d-m-Y H:i:s')); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <?php echo e($logs->links()); ?>

    <?php else: ?>
        <p class="mt-4">No activity logs available.</p>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\admin\activity-logs.blade.php ENDPATH**/ ?>