


<?php $__env->startSection('title', 'IB Earnings Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-12 text-center">
            <h2 class="mt-4 fw-bold text-primary border-bottom pb-3">
                <i class="fas fa-chart-line me-2"></i> IB Earnings Report
            </h2>
        </div>
    </div>

    <!-- Summary Section -->
    <div class="row g-4">
        <div class="col-lg-3 col-md-6">
            <div class="card shadow-sm border-0 rounded-4 gradient-bg-green text-white hover-effect">
                <div class="card-body text-center">
                    <h5 class="fw-bold">Total Earnings</h5>
                    <h3 class="fw-bold">$<?php echo e(number_format($totalEarnings, 2)); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="card shadow-sm border-0 rounded-4 gradient-bg-blue text-white hover-effect">
                <div class="card-body text-center">
                    <h5 class="fw-bold">Total IBs</h5>
                    <h3 class="fw-bold"><?php echo e($totalIBs); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="card shadow-sm border-0 rounded-4 gradient-bg-cyan text-white hover-effect">
                <div class="card-body text-center">
                    <h5 class="fw-bold">Active Referrals</h5>
                    <h3 class="fw-bold"><?php echo e($totalActiveReferrals); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="card shadow-sm border-0 rounded-4 gradient-bg-red text-white hover-effect">
                <div class="card-body text-center">
                    <h5 class="fw-bold">Inactive Referrals</h5>
                    <h3 class="fw-bold"><?php echo e($totalInactiveReferrals); ?></h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Earnings Overview Section -->
    <div class="card shadow-lg border-0 mt-5 rounded-4">
        <div class="card-header bg-gradient-primary text-white d-flex justify-content-between align-items-center rounded-top">
            <strong><i class="fas fa-coins me-2"></i> Earnings Overview</strong>
            <span class="fw-bold fs-5">Total Earnings: <span class="text-warning">$<?php echo e(number_format($totalEarnings, 2)); ?></span></span>
        </div>
        <div class="card-body p-4 bg-light">
            <?php if($earnings->isEmpty()): ?>
                <div class="alert alert-info text-center">
                    <i class="fas fa-info-circle me-2"></i> No earnings found.
                </div>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-hover table-bordered align-middle mb-0">
                        <thead class="table-primary">
                            <tr class="text-center fw-bold">
                                <th>#</th>
                                <th>Referrer Name</th>
                                <th>Referred User</th>
                                <th>Earnings ($)</th>
                                <th>Status</th>
                                <th>Level</th>
                                <th>Created At</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $earnings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $earning): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e($earning->referrer->name ?? 'Unknown'); ?></td>
                                    <td><?php echo e($earning->referredUser->name ?? 'Unknown'); ?></td>
                                    <td>$<?php echo e(number_format($earning->earnings, 2)); ?></td>
                                    <td>
                                        <span class="badge <?php echo e($earning->referredUser->is_active ? 'bg-success' : 'bg-danger'); ?>">
                                            <?php echo e($earning->referredUser->is_active ? 'Active' : 'Inactive'); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e($earning->referrer->ibHierarchy->level ?? 'N/A'); ?></td>
                                    <td><?php echo e($earning->created_at->format('d M Y H:i')); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('admin.ib.earnings.show', $earning->id)); ?>" class="btn btn-outline-info btn-sm">
                                            <i class="fas fa-eye"></i> Details
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-center mt-4">
                    <?php echo e($earnings->links('pagination::bootstrap-5')); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Charts Section -->
    <div class="row g-4 mt-5">
        <!-- Earnings by Status Chart -->
        <div class="col-md-6">
            <div class="card shadow-sm border-0 rounded-4">
                <div class="card-header bg-gradient-info text-white">
                    <strong><i class="fas fa-chart-pie me-2"></i> Earnings by Status</strong>
                </div>
                <div class="card-body">
                    <canvas id="earningsStatusChart"></canvas>
                </div>
            </div>
        </div>
        <!-- Earnings Distribution Chart -->
        <div class="col-md-6">
            <div class="card shadow-sm border-0 rounded-4">
                <div class="card-header bg-gradient-warning text-dark">
                    <strong><i class="fas fa-chart-bar me-2"></i> Earnings Distribution</strong>
                </div>
                <div class="card-body">
                    <canvas id="earningsDistributionChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .gradient-bg-green { background: linear-gradient(135deg, #32a852, #28b463); }
    .gradient-bg-blue { background: linear-gradient(135deg, #0066cc, #007bff); }
    .gradient-bg-cyan { background: linear-gradient(135deg, #17a2b8, #00d4ff); }
    .gradient-bg-red { background: linear-gradient(135deg, #dc3545, #ff6b6b); }
    .hover-effect { transition: transform 0.3s ease, box-shadow 0.3s ease; }
    .hover-effect:hover { transform: translateY(-5px); box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2); }
</style>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const ctxStatus = document.getElementById('earningsStatusChart').getContext('2d');
        new Chart(ctxStatus, {
            type: 'pie',
            data: {
                labels: ['Active', 'Inactive'],
                datasets: [{
                    data: [<?php echo e($totalActiveEarnings); ?>, <?php echo e($totalInactiveEarnings); ?>],
                    backgroundColor: ['#28a745', '#dc3545']
                }]
            },
            options: {
                responsive: true,
                plugins: { legend: { position: 'bottom' } }
            }
        });

        const ctxDistribution = document.getElementById('earningsDistributionChart').getContext('2d');
        new Chart(ctxDistribution, {
            type: 'bar',
            data: {
                labels: <?php echo json_encode($earnings->pluck('referrer.name'), 15, 512) ?>,
                datasets: [{
                    label: 'Earnings ($)',
                    data: <?php echo json_encode($earnings->pluck('earnings'), 15, 512) ?>,
                    backgroundColor: '#ffc107',
                    borderColor: '#fd7e14',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                scales: {
                    y: { beginAtZero: true },
                    x: { title: { display: true, text: 'Referrers' } }
                }
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\admin\ib-earnings.blade.php ENDPATH**/ ?>