

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <h1 class="mt-4 mb-4 text-center text-gradient">Welcome, <?php echo e(Auth::user()->name); ?></h1>

    <!-- Statistics Section -->
    <div class="row g-3">
        <div class="col-md-3">
            <div class="card shadow border-0" style="background: linear-gradient(to right, #1e3c72, #2a5298);">
                <div class="card-body text-center text-white">
                    <i class="fas fa-wallet fa-2x mb-3"></i>
                    <h5 class="card-title">Wallet Balance</h5>
                    <h3>$<?php echo e(number_format($walletBalance, 2)); ?></h3>
                </div>
                <div class="card-footer text-end text-white">
                    <a href="<?php echo e(route('user.wallet.index')); ?>" class="text-white">View Wallet <i class="fas fa-arrow-right"></i></a>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card shadow border-0" style="background: linear-gradient(to right, #56ab2f, #a8e063);">
                <div class="card-body text-center text-white">
                    <i class="fas fa-chart-line fa-2x mb-3"></i>
                    <h5 class="card-title">Open Trades</h5>
                    <h3><?php echo e($openTrades); ?></h3>
                </div>
                <div class="card-footer text-end text-white">
                    <a href="<?php echo e(route('user.trades')); ?>" class="text-white">View Trades <i class="fas fa-arrow-right"></i></a>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card shadow border-0" style="background: linear-gradient(to right, #f12711, #f5af19);">
                <div class="card-body text-center text-white">
                    <i class="fas fa-users fa-2x mb-3"></i>
                    <h5 class="card-title">Referral Earnings</h5>
                    <h3>$<?php echo e(number_format($referralEarnings, 2)); ?></h3>
                </div>
                <div class="card-footer text-end text-white">
                    <a href="<?php echo e(route('referrals.index')); ?>" class="text-white">View Referrals <i class="fas fa-arrow-right"></i></a>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card shadow border-0" style="background: linear-gradient(to right, #43cea2, #185a9d);">
                <div class="card-body text-center text-white">
                    <i class="fas fa-sitemap fa-2x mb-3"></i>
                    <h5 class="card-title">IB Tree</h5>
                    <h3><?php echo e($totalReferrals); ?></h3>
                </div>
                <div class="card-footer text-end text-white">
                    <a href="<?php echo e(route('user.ib.tree')); ?>" class="text-white">View IB Tree <i class="fas fa-arrow-right"></i></a>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Links Section -->
    <div class="row my-4">
        <div class="col-md-12">
            <div class="card shadow border-0">
                <div class="card-header bg-gradient ">
                    <i class="fas fa-link me-2"></i> Quick Links
                </div>
                <div class="card-body text-center">
                    <a href="<?php echo e(route('user.wallet.index')); ?>" class="btn btn-outline-primary me-2"><i class="fas fa-wallet me-1"></i> Wallet</a>
                    <a href="<?php echo e(route('user.trades')); ?>" class="btn btn-outline-success me-2"><i class="fas fa-chart-line me-1"></i> Trades</a>
                    <a href="<?php echo e(route('referrals.index')); ?>" class="btn btn-outline-warning me-2"><i class="fas fa-users me-1"></i> Referrals</a>
                    <a href="<?php echo e(route('user.ib.tree')); ?>" class="btn btn-outline-info"><i class="fas fa-sitemap me-1"></i> IB Tree</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Section -->
    <div class="row my-4 g-3">
        <div class="col-md-6">
            <div class="card shadow border-0">
                <div class="card-header bg-dark text-white">
                    <i class="fas fa-chart-line me-2"></i> Monthly Profit/Loss
                </div>
                <div class="card-body">
                    <canvas id="tradingChart"></canvas>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card shadow border-0">
                <div class="card-header bg-dark text-white">
                    <i class="fas fa-pie-chart me-2"></i> Top Traded Assets
                </div>
                <div class="card-body">
                    <canvas id="topAssetsChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="row my-4 g-3">
        <div class="col-md-6">
            <div class="card shadow border-0">
                <div class="card-header bg-info text-white">
                    <i class="fas fa-exchange-alt me-2"></i> Funds Transfer History
                </div>
                <div class="card-body">
                    <canvas id="fundsTransferChart"></canvas>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card shadow border-0">
                <div class="card-header bg-warning text-dark">
                    <i class="fas fa-money-check-alt me-2"></i> Total Deposit vs Withdrawal
                </div>
                <div class="card-body">
                    <canvas id="depositWithdrawChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
    .text-gradient {
        background: linear-gradient(to right, #ff7e5f, #feb47b);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
    }
    .bg-gradient {
        background: linear-gradient(to right, #2193b0, #6dd5ed);
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Chart Scripts (same as your existing charts)
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\user\dashboard.blade.php ENDPATH**/ ?>