

<?php $__env->startSection('title', 'Support Tickets'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <h2 class="mt-4 text-primary fw-bold">
        <i class="fas fa-life-ring me-2"></i> Support Tickets
    </h2>
    <div class="card shadow-lg border-0 mb-4 rounded-4">
        <div class="card-header bg-gradient-primary text-white d-flex justify-content-between align-items-center rounded-top">
            <h5 class="m-0">
                <i class="fas fa-ticket-alt me-2"></i> All Tickets
            </h5>
            <form class="d-flex align-items-center" method="GET" action="<?php echo e(route('admin.support.index')); ?>">
                <div class="me-2">
                    <select name="status" class="form-select form-select-sm shadow-sm" onchange="this.form.submit()">
                        <option value="">All Status</option>
                        <option value="open" <?php echo e(request('status') == 'open' ? 'selected' : ''); ?>>Open</option>
                        <option value="in_progress" <?php echo e(request('status') == 'in_progress' ? 'selected' : ''); ?>>In Progress</option>
                        <option value="completed" <?php echo e(request('status') == 'completed' ? 'selected' : ''); ?>>Completed</option>
                        <option value="closed" <?php echo e(request('status') == 'closed' ? 'selected' : ''); ?>>Closed</option>
                    </select>
                </div>
                <div class="input-group input-group-sm">
                    <input type="text" name="search" class="form-control shadow-sm" placeholder="Search tickets..." value="<?php echo e(request('search')); ?>">
                    <button type="submit" class="btn btn-light">
                        <i class="fas fa-search"></i>
                    </button>
                </div>
            </form>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover table-striped align-middle mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th>
                            <th>User</th>
                            <th>Subject</th>
                            <th>Status</th>
                            <th>Created At</th>
                            <th>Updated At</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><strong>#<?php echo e($ticket->id); ?></strong></td>
                                <td>
                                    <strong><?php echo e($ticket->user->name); ?></strong><br>
                                    <small class="text-muted"><?php echo e($ticket->user->email); ?></small>
                                </td>
                                <td>
                                    <span class="text-truncate d-inline-block" style="max-width: 200px;" title="<?php echo e($ticket->subject); ?>">
                                        <?php echo e($ticket->subject); ?>

                                    </span>
                                </td>
                                <td>
                                    <span class="badge rounded-pill 
                                        <?php if($ticket->status == 'open'): ?> bg-primary 
                                        <?php elseif($ticket->status == 'in_progress'): ?> bg-warning text-dark 
                                        <?php elseif($ticket->status == 'completed'): ?> bg-success 
                                        <?php elseif($ticket->status == 'closed'): ?> bg-danger 
                                        <?php endif; ?>">
                                        <?php echo e(ucfirst(str_replace('_', ' ', $ticket->status))); ?>

                                    </span>
                                </td>
                                <td><?php echo e($ticket->created_at->format('d M Y, h:i A')); ?></td>
                                <td><?php echo e($ticket->updated_at->format('d M Y, h:i A')); ?></td>
                                <td>
                                    <div class="btn-group">
                                        <a href="<?php echo e(route('admin.support.show', $ticket->id)); ?>" class="btn btn-sm btn-info shadow-sm rounded-pill" title="View Ticket">
                                            <i class="fas fa-eye"></i> View
                                        </a>
                                        <button type="button" class="btn btn-sm btn-warning shadow-sm rounded-pill" title="Update Status" onclick="openUpdateStatusModal(<?php echo e($ticket->id); ?>, '<?php echo e($ticket->status); ?>')">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center text-muted py-4">No tickets found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="mt-3 d-flex justify-content-center">
                <?php echo e($tickets->links('pagination::bootstrap-5')); ?>

            </div>
        </div>
    </div>
</div>

<!-- Update Status Modal -->
<div class="modal fade" id="updateStatusModal" tabindex="-1" aria-labelledby="updateStatusModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
           <form method="POST" action="" id="updateStatusForm">
    <?php echo csrf_field(); ?>
    <!-- Add this to indicate a PUT request -->
    <div class="modal-header bg-gradient-primary text-white">
        <h5 class="modal-title" id="updateStatusModalLabel">Update Ticket Status</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
    </div>
    <div class="modal-body">
        <p class="mb-2">Change the status of this ticket:</p>
        <select name="status" class="form-select shadow-sm">
            <option value="open">Open</option>
            <option value="in_progress">In Progress</option>
            <option value="completed">Completed</option>
            <option value="closed">Closed</option>
        </select>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-secondary shadow-sm" data-bs-dismiss="modal">Cancel</button>
        <button type="submit" class="btn btn-primary shadow-sm">Update</button>
    </div>
</form>

        </div>
    </div>
</div>

<script>
    function openUpdateStatusModal(ticketId, currentStatus) {
        const modal = document.getElementById('updateStatusModal');
        const form = document.getElementById('updateStatusForm');
        form.action = `/admin/support/${ticketId}/update-status`;
        form.querySelector('select[name="status"]').value = currentStatus;
        const bootstrapModal = new bootstrap.Modal(modal);
        bootstrapModal.show();
    }
</script>

<style>
/* Enhanced Table Styling */
.table-hover tbody tr:hover {
    background: rgba(0, 123, 255, 0.1);
}
.badge {
    font-size: 0.85rem;
    padding: 6px 12px;
    font-weight: 500;
}
.text-truncate {
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
}
.modal-header {
    background: linear-gradient(45deg, #007bff, #0056b3);
}
.modal-footer button {
    min-width: 100px;
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\admin\support\index.blade.php ENDPATH**/ ?>