

<?php $__env->startSection('title', 'Email Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mt-4 mb-4">
        <h1 class="h3 fw-bold text-primary">
            <i class="fas fa-envelope me-2"></i> Email Settings
        </h1>
    </div>

    <!-- Email Settings Form -->
    <div class="card shadow-lg border-0 mb-5">
        <div class="card-header bg-gradient-primary text-white d-flex align-items-center">
            <h4 class="mb-0"><i class="fas fa-cogs me-2"></i> Configure SMTP Settings</h4>
        </div>
        <div class="card-body p-4">
            <form action="<?php echo e(route('admin.email-settings.update')); ?>" method="POST" class="email-settings-form bg-white p-5 rounded shadow-sm border border-light">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <div class="mb-4">
                    <label class="form-label fw-semibold">SMTP Host</label>
                    <input type="text" name="smtp_host" value="<?php echo e($emailSettings->smtp_host ?? ''); ?>" class="form-control form-control-lg" required>
                </div>

                <div class="mb-4">
                    <label class="form-label fw-semibold">SMTP Port</label>
                    <input type="number" name="smtp_port" value="<?php echo e($emailSettings->smtp_port ?? ''); ?>" class="form-control form-control-lg" required>
                </div>

                <div class="mb-4">
                    <label class="form-label fw-semibold">SMTP Username</label>
                    <input type="text" name="smtp_username" value="<?php echo e($emailSettings->smtp_username ?? ''); ?>" class="form-control form-control-lg" required>
                </div>

                <div class="mb-4">
                    <label class="form-label fw-semibold">SMTP Password</label>
                    <input type="password" name="smtp_password" value="<?php echo e($emailSettings->smtp_password ?? ''); ?>" class="form-control form-control-lg" required>
                </div>

                <div class="mb-4">
                    <label class="form-label fw-semibold">SMTP Encryption</label>
                    <select name="smtp_encryption" class="form-select form-select-lg">
                        <option value="">None</option>
                        <option value="tls" <?php echo e(isset($emailSettings) && $emailSettings->smtp_encryption == 'tls' ? 'selected' : ''); ?>>TLS</option>
                        <option value="ssl" <?php echo e(isset($emailSettings) && $emailSettings->smtp_encryption == 'ssl' ? 'selected' : ''); ?>>SSL</option>
                    </select>
                </div>

                <div class="mb-4">
                    <label class="form-label fw-semibold">From Email</label>
                    <input type="email" name="from_email" value="<?php echo e($emailSettings->from_email ?? ''); ?>" class="form-control form-control-lg" required>
                </div>

                <div class="mb-4">
                    <label class="form-label fw-semibold">From Name</label>
                    <input type="text" name="from_name" value="<?php echo e($emailSettings->from_name ?? ''); ?>" class="form-control form-control-lg" required>
                </div>

                <div class="text-end">
                    <button type="submit" class="btn btn-gradient-primary btn-lg shadow">
                        <i class="fas fa-save"></i> Save Settings
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\admin\email_settings.blade.php ENDPATH**/ ?>