<ul class="tree">
    <?php $__currentLoopData = $children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $node): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <li class="tree-node-wrapper">
            <!-- Node -->
            <div class="tree-node" data-bs-toggle="tooltip" title="Email: <?php echo e($node['user']->email); ?>">
                <div class="node-content">
                    <div class="node-header d-flex align-items-center justify-content-center">
                        <div class="node-icon me-2">
                            <i class="bi bi-person-circle fs-3 text-primary"></i>
                        </div>
                        <div class="node-details">
                            <strong class="node-name"><?php echo e($node['user']->name); ?></strong>
                            <div class="node-email small"><?php echo e($node['user']->email); ?></div>
                            <div class="node-level">Level: <?php echo e($node['level']); ?></div>
                        </div>
                    </div>
                    <div class="node-status mt-2">
                        <span class="badge <?php echo e($node['user']->is_active ? 'bg-success' : 'bg-danger'); ?>">
                            <?php echo e($node['user']->is_active ? 'Active' : 'Inactive'); ?>

                        </span>
                    </div>
                </div>
            </div>
            <!-- Recursively Include Children -->
            <?php if(!empty($node['children'])): ?>
                <ul class="tree">
                    <?php echo $__env->make('user.partials.tree-children', ['children' => $node['children']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </ul>
            <?php endif; ?>
        </li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</ul>

<style>
/* Tree Styling */
.tree {
    display: flex;
    justify-content: center;
    align-items: flex-start;
    padding: 0;
    margin: 0;
    white-space: nowrap;
    position: relative;
    text-align: center;
    width: 100%;
}

.tree ul {
    padding-top: 50px;
    position: relative;
    display: flex;
    justify-content: center;
    align-items: flex-start;
    padding-left: 0;
    margin-bottom: 20px;
    width: 100%;
    gap: 20px; /* Gap between nodes */
}

.tree li {
    list-style: none;
    text-align: center;
    position: relative;
    padding: 20px 5px 0 5px;
    display: inline-flex;
    flex-direction: column;
    align-items: center;
    margin: 0 15px;
    flex-grow: 1;
    min-width: 150px;
}

/* Connector Lines */
.tree li::before,
.tree li::after {
    content: '';
    position: absolute;
    top: 0;
    right: 50%;
    border-top: 2px solid #007bff;
    width: 50%;
    height: 20px;
}

.tree li::after {
    left: 50%;
    border-left: 2px solid #007bff;
}

.tree li:only-child::after,
.tree li:only-child::before {
    display: none;
}

.tree li:first-child::before,
.tree li:last-child::after {
    border: 0 none;
}

.tree li:last-child::before {
    border-right: 2px solid #007bff;
    border-radius: 0 5px 0 0;
}

.tree li:first-child::after {
    border-radius: 5px 0 0 0;
}

/* Root Connection Line */
.tree ul::before {
    content: '';
    position: absolute;
    top: -20px;
    left: 50%;
    transform: translateX(-50%);
    border-left: 2px solid #007bff;
    height: 20px;
}

/* Node Styling */
.tree-node {
    border: 2px solid #007bff;
    padding: 20px;
    width: 180px;
    height: 160px;
    border-radius: 15px;
    background: linear-gradient(145deg, #f9f9f9, #e9ecef);
    box-shadow: 0px 12px 30px rgba(0, 0, 0, 0.15);
    transition: transform 0.4s ease-in-out, box-shadow 0.4s ease-in-out;
    position: relative;
    animation: fadeIn 1s ease-in-out;
}

.tree-node:hover {
    transform: scale(1.1);
    box-shadow: 0px 20px 40px rgba(0, 0, 0, 0.25);
    cursor: pointer;
}

/* Node Content */
.node-content {
    display: flex;
    flex-direction: column;
    align-items: center;
}

/* Node Icon */
.node-icon {
    margin-bottom: 10px;
}

.bi-person-circle {
    font-size: 3rem;
}

/* Node Details */
.node-details {
    text-align: center;
}

.node-name {
    font-size: 1.2rem;
    font-weight: bold;
    color: #0056b3;
}

.node-email,
.node-level {
    font-size: 0.85rem;
    color: #6c757d;
}

/* Status Badge Inside Box */
.node-status {
    text-align: center;
    margin-top: 10px;
}

.badge {
    font-size: 0.8rem;
    padding: 6px 12px;
    border-radius: 20px;
    font-weight: bold;
}

/* Badge Colors */
.bg-success {
    background: #28a745 !important;
    color: white !important;
}

.bg-danger {
    background: #dc3545 !important;
    color: white !important;
}

/* Responsive Design */
@media (max-width: 768px) {
    .node-icon {
        font-size: 2rem;
    }

    .node-name {
        font-size: 1rem;
    }

    .tree ul {
        flex-direction: column;
    }

    .tree li {
        width: auto;
    }

    .tree-node {
        width: 140px;
        height: 130px;
        padding: 10px;
    }
}

/* Keyframes for Animations */
@keyframes fadeIn {
    from {
        opacity: 0;
        transform: scale(0.8);
    }
    to {
        opacity: 1;
        transform: scale(1);
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    tooltipTriggerList.forEach(function (tooltipTriggerEl) {
        new bootstrap.Tooltip(tooltipTriggerEl);
    });
});
</script>
<?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\user\partials\tree-children.blade.php ENDPATH**/ ?>