

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <h1 class="mt-4 mb-4 text-primary"><i class="fas fa-cogs me-2"></i> Admin Settings</h1>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <form action="<?php echo e(route('admin.settings.update')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <!-- Fund Transfer Limit -->
        <div class="mb-4">
            <label for="fund_transfer_limit" class="form-label">Fund Transfer Limit</label>
            <input type="number" name="fund_transfer_limit" id="fund_transfer_limit" class="form-control" value="<?php echo e($settings['fund_transfer_limit'] ?? 1000); ?>" min="0">
        </div>

        <!-- Fund Transfer Minimum -->
        <div class="mb-4">
            <label for="fund_transfer_minimum" class="form-label">Minimum Fund Transfer Amount</label>
            <input type="number" name="fund_transfer_minimum" id="fund_transfer_minimum" class="form-control" value="<?php echo e($settings['fund_transfer_minimum'] ?? 50); ?>" min="0">
        </div>

        <!-- Transaction Fee -->
        <div class="mb-4">
            <label for="transaction_fee" class="form-label">Transaction Fee (%)</label>
            <input type="number" name="transaction_fee" id="transaction_fee" class="form-control" value="<?php echo e($settings['transaction_fee'] ?? 2); ?>" min="0" max="100">
        </div>

        <!-- Default Currency -->
        <div class="mb-4">
            <label for="currency" class="form-label">Default Currency</label>
            <input type="text" name="currency" id="currency" class="form-control" value="<?php echo e($settings['currency'] ?? 'USD'); ?>" maxlength="10">
        </div>

        <!-- Enable/Disable Fund Transfers -->
        <div class="mb-4">
            <label for="fund_transfers" class="form-label">Enable Fund Transfers</label>
            <select name="fund_transfers" id="fund_transfers" class="form-select">
                <option value="1" <?php echo e(isset($settings['fund_transfers']) && $settings['fund_transfers'] == '1' ? 'selected' : ''); ?>>Enabled</option>
                <option value="0" <?php echo e(isset($settings['fund_transfers']) && $settings['fund_transfers'] == '0' ? 'selected' : ''); ?>>Disabled</option>
            </select>
        </div>

        <!-- Allow User Management -->
        <div class="mb-4">
            <label for="allow_user_management" class="form-label">Allow User Management</label>
            <select name="allow_user_management" id="allow_user_management" class="form-select">
                <option value="1" <?php echo e(isset($settings['allow_user_management']) && $settings['allow_user_management'] == '1' ? 'selected' : ''); ?>>Enabled</option>
                <option value="0" <?php echo e(isset($settings['allow_user_management']) && $settings['allow_user_management'] == '0' ? 'selected' : ''); ?>>Disabled</option>
            </select>
        </div>

        <!-- Enable Trade Management -->
        <div class="mb-4">
            <label for="trade_management" class="form-label">Enable Trade Management</label>
            <select name="trade_management" id="trade_management" class="form-select">
                <option value="1" <?php echo e(isset($settings['trade_management']) && $settings['trade_management'] == '1' ? 'selected' : ''); ?>>Enabled</option>
                <option value="0" <?php echo e(isset($settings['trade_management']) && $settings['trade_management'] == '0' ? 'selected' : ''); ?>>Disabled</option>
            </select>
        </div>

        <!-- User Registration Setting -->
        <div class="mb-4">
            <label for="user_registration" class="form-label">Allow User Registration</label>
            <select name="user_registration" id="user_registration" class="form-select">
                <option value="1" <?php echo e(isset($settings['user_registration']) && $settings['user_registration'] == '1' ? 'selected' : ''); ?>>Enabled</option>
                <option value="0" <?php echo e(isset($settings['user_registration']) && $settings['user_registration'] == '0' ? 'selected' : ''); ?>>Disabled</option>
            </select>
        </div>

        <button type="submit" class="btn btn-primary"><i class="fas fa-save me-2"></i> Save Settings</button>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\admin\settings.blade.php ENDPATH**/ ?>