

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h2 class="mb-4">MT5 Trades</h2>

    <?php if(session('error')): ?>
        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

    <?php if(isset($trades) && count($trades) > 0): ?>
        <div class="table-responsive">
            <table class="table table-striped table-bordered">
                <thead class="table-dark">
                    <tr>
                        <th>Ticket</th>
                        <th>Login</th>
                        <th>Symbol</th>
                        <th>Type</th>
                        <th>Volume</th>
                        <th>Profit</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $trades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($trade['ticket']); ?></td>
                            <td><?php echo e($trade['login']); ?></td>
                            <td><?php echo e($trade['symbol']); ?></td>
                            <td>
                                <?php if($trade['type'] === 'buy'): ?>
                                    <span class="badge bg-success">Buy</span>
                                <?php elseif($trade['type'] === 'sell'): ?>
                                    <span class="badge bg-danger">Sell</span>
                                <?php else: ?>
                                    <span class="badge bg-secondary">Other</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e(number_format($trade['volume'], 2)); ?></td>
                            <td><?php echo e(number_format($trade['profit'], 2)); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="alert alert-warning">No trades found.</div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\admin\trades.blade.php ENDPATH**/ ?>