

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h2 class="mb-4 text-center text-primary">
        <i class="fas fa-id-card me-2"></i> KYC Document Details
    </h2>

    <!-- User Details Section -->
    <div class="card shadow-sm mb-4">
        <div class="card-header bg-primary text-white">
            <strong>User Information</strong>
        </div>
        <div class="card-body">
            <p><strong>Name:</strong> <?php echo e($kyc->user->name); ?></p>
            <p><strong>Email:</strong> <?php echo e($kyc->user->email); ?></p>
            <p><strong>Status:</strong> 
                <span class="badge bg-<?php echo e($kyc->status === 'approved' ? 'success' : ($kyc->status === 'rejected' ? 'danger' : 'warning')); ?>">
                    <?php echo e(ucfirst($kyc->status)); ?>

                </span>
            </p>
            <p><strong>Submitted On:</strong> <?php echo e($kyc->created_at->format('d M, Y H:i')); ?></p>
            <p><strong>Last Updated:</strong> <?php echo e($kyc->updated_at->diffForHumans()); ?></p>
        </div>
    </div>

    <!-- Documents Section -->
    <div class="card shadow-sm mb-4">
        <div class="card-header bg-secondary text-white">
            <strong>KYC Documents</strong>
        </div>
        <div class="card-body">
            <div class="row">
                <?php if($kyc->passport): ?>
                    <div class="col-md-6 mb-3">
                        <strong>Passport:</strong>
                        <img src="<?php echo e(asset('storage/' . $kyc->passport)); ?>" alt="Passport" class="img-thumbnail mb-2" style="max-width: 100%; max-height: 200px;">
                        <a href="<?php echo e(asset('storage/' . $kyc->passport)); ?>" target="_blank" class="btn btn-sm btn-primary" data-bs-toggle="tooltip" title="View Passport">
                            <i class="fas fa-eye"></i> View Passport
                        </a>
                        <a href="<?php echo e(asset('storage/' . $kyc->passport)); ?>" class="btn btn-sm btn-success" download data-bs-toggle="tooltip" title="Download Passport">
                            <i class="fas fa-download"></i> Download
                        </a>
                    </div>
                <?php endif; ?>
                <?php if($kyc->driver_license): ?>
                    <div class="col-md-6 mb-3">
                        <strong>Driver License:</strong>
                        <img src="<?php echo e(asset('storage/' . $kyc->driver_license)); ?>" alt="Driver License" class="img-thumbnail mb-2" style="max-width: 100%; max-height: 200px;">
                        <a href="<?php echo e(asset('storage/' . $kyc->driver_license)); ?>" target="_blank" class="btn btn-sm btn-primary" data-bs-toggle="tooltip" title="View Driver License">
                            <i class="fas fa-eye"></i> View Driver License
                        </a>
                        <a href="<?php echo e(asset('storage/' . $kyc->driver_license)); ?>" class="btn btn-sm btn-success" download data-bs-toggle="tooltip" title="Download Driver License">
                            <i class="fas fa-download"></i> Download
                        </a>
                    </div>
                <?php endif; ?>
                <?php if($kyc->nid): ?>
                    <div class="col-md-6 mb-3">
                        <strong>NID:</strong>
                        <img src="<?php echo e(asset('storage/' . $kyc->nid)); ?>" alt="NID" class="img-thumbnail mb-2" style="max-width: 100%; max-height: 200px;">
                        <a href="<?php echo e(asset('storage/' . $kyc->nid)); ?>" target="_blank" class="btn btn-sm btn-primary" data-bs-toggle="tooltip" title="View NID">
                            <i class="fas fa-eye"></i> View NID
                        </a>
                        <a href="<?php echo e(asset('storage/' . $kyc->nid)); ?>" class="btn btn-sm btn-success" download data-bs-toggle="tooltip" title="Download NID">
                            <i class="fas fa-download"></i> Download
                        </a>
                    </div>
                <?php endif; ?>
                <?php if($kyc->other_documents): ?>
                    <div class="col-md-6 mb-3">
                        <strong>Other Documents:</strong>
                        <img src="<?php echo e(asset('storage/' . $kyc->other_documents)); ?>" alt="Other Documents" class="img-thumbnail mb-2" style="max-width: 100%; max-height: 200px;">
                        <a href="<?php echo e(asset('storage/' . $kyc->other_documents)); ?>" target="_blank" class="btn btn-sm btn-primary" data-bs-toggle="tooltip" title="View Other Documents">
                            <i class="fas fa-eye"></i> View Other Documents
                        </a>
                        <a href="<?php echo e(asset('storage/' . $kyc->other_documents)); ?>" class="btn btn-sm btn-success" download data-bs-toggle="tooltip" title="Download Other Documents">
                            <i class="fas fa-download"></i> Download
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Approval and Rejection Section -->
    <div class="card shadow-sm mb-4">
        <div class="card-header bg-dark text-white">
            <strong>Admin Actions</strong>
        </div>
        <div class="card-body">
            <div class="d-flex justify-content-between">
                <!-- Approve Button -->
                <form action="<?php echo e(route('admin.kyc.approve', $kyc->id)); ?>" method="POST" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-success btn-lg" data-bs-toggle="tooltip" title="Approve KYC">
                        <i class="fas fa-check-circle"></i> Approve KYC
                    </button>
                </form>

                <!-- Reject Button -->
                <form action="<?php echo e(route('admin.kyc.reject', $kyc->id)); ?>" method="POST" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <div class="input-group">
                        <input type="text" name="admin_remark" class="form-control form-control-sm" placeholder="Reason for rejection" required>
                        <button type="submit" class="btn btn-danger btn-lg" data-bs-toggle="tooltip" title="Reject KYC">
                            <i class="fas fa-times-circle"></i> Reject KYC
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Custom Tooltip Initialization -->
<?php $__env->startSection('scripts'); ?>
<script>
    // Enable tooltips
    document.querySelectorAll('[data-bs-toggle="tooltip"]').forEach((tooltipElement) => {
        new bootstrap.Tooltip(tooltipElement);
    });
</script>
<?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\admin\kyc\show.blade.php ENDPATH**/ ?>