

<?php $__env->startSection('title', 'Manage Roles'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <h2 class="mt-4 mb-4 text-primary"><i class="fas fa-tools"></i> Manage Roles</h2>

    <!-- Roles Table Section -->
    <div class="card shadow-lg border-0 rounded">
        <div class="card-header bg-gradient-primary text-white d-flex justify-content-between align-items-center rounded-top">
            <h5 class="mb-0"><i class="fas fa-list"></i> Role List</h5>
            <a href="<?php echo e(route('admin.roles.create')); ?>" class="btn btn-light btn-sm shadow-sm">
                <i class="fas fa-user-plus"></i> Add New Role
            </a>
        </div>
        <div class="card-body">
            <?php if($roles->isEmpty()): ?>
                <div class="alert alert-info text-center">
                    <i class="fas fa-info-circle"></i> No roles found.
                </div>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-primary">
                            <tr class="text-center">
                                <th>#</th>
                                <th>Name</th>
                                <th>Permissions</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody class="border-top">
                            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="text-center">
                                    <td><?php echo e($role->id); ?></td>
                                    <td><?php echo e(ucfirst($role->name)); ?></td>
                                    <td><?php echo e($role->permissions->pluck('name')->join(', ')); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('admin.roles.edit', $role->id)); ?>" class="btn btn-warning btn-sm shadow-sm">
                                            <i class="fas fa-edit"></i> Edit
                                        </a>

                                        <a href="<?php echo e(route('admin.roles.showUsers', $role->id)); ?>" class="btn btn-info btn-sm shadow-sm">
                                            <i class="fas fa-users"></i> Show Users
                                        </a>

                                        <form action="<?php echo e(route('admin.roles.delete', $role->id)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this role?');">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-danger btn-sm shadow-sm">
                                                <i class="fas fa-trash-alt"></i> Delete
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-center mt-4">
                    <?php echo e($roles->links('pagination::bootstrap-5')); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\admin\roles\index.blade.php ENDPATH**/ ?>