

<?php $__env->startSection('title', 'My IB Tree'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <div class="row mb-4">
        <div class="col-12 text-center">
            <h2 class="mt-4 text-primary fw-bold">
                <i class="fas fa-sitemap me-2"></i> My IB Tree
            </h2>
        </div>
    </div>

    <div class="card shadow-lg border-0 mb-5 rounded-4">
        <div class="card-header bg-gradient-primary text-white d-flex justify-content-between align-items-center rounded-top">
            <strong><i class="fas fa-network-wired me-2"></i> My IB Tree Structure</strong>
            <a href="<?php echo e(route('user.dashboard')); ?>" class="btn btn-light btn-sm shadow-sm rounded-pill">
                <i class="fas fa-arrow-left me-2"></i> Back to Dashboard
            </a>
        </div>
        <div class="card-body text-center p-4">
            <?php if(!empty($tree)): ?>
                <div class="tree-container mt-4">
                    <ul class="tree">
                        <li>
                            <div class="tree-node" data-bs-toggle="tooltip" title="Name: <?php echo e($user->name); ?> | Email: <?php echo e($user->email); ?>">
                                <i class="fas fa-user-circle fa-lg mb-2 text-primary"></i>
                                <div class="node-content">
                                    <strong class="node-name"><?php echo e($user->name); ?></strong>
                                    <div class="node-email small"><?php echo e($user->email); ?></div>
                                    <span class="badge <?php echo e($user->is_active ? 'bg-success' : 'bg-danger'); ?>">
                                        <?php echo e($user->is_active ? 'Active' : 'Inactive'); ?>

                                    </span>
                                </div>
                            </div>
                            <?php echo $__env->make('user.partials.tree-children', ['children' => $tree], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </li>
                    </ul>
                </div>
            <?php else: ?>
                <div class="alert alert-info text-center mt-3">
                    <i class="fas fa-info-circle me-2"></i> No referrals found in your tree.
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
/* Tree Container */
.tree-container {
    display: flex;
    justify-content: center;
    align-items: center;
    overflow-x: auto;
    padding: 30px;
    background: linear-gradient(135deg, #f9fbfd, #eef2f7);
    border-radius: 15px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
}

/* Tree Structure */
.tree {
    list-style: none;
    padding: 0;
    margin: 0 auto;
    text-align: center;
    position: relative;
}

.tree ul {
    padding-top: 40px;
    display: flex;
    justify-content: center;
    position: relative;
    gap: 30px;
}

.tree ul li {
    list-style: none;
    text-align: center;
    position: relative;
}

/* Connecting Lines */
.tree ul li::before,
.tree ul li::after {
    content: '';
    position: absolute;
    top: -20px;
    border-top: 2px solid #007bff;
    width: 50%;
    height: 20px;
}

.tree ul li::before {
    right: 50%;
}

.tree ul li::after {
    left: 50%;
    border-left: 2px solid #007bff;
}

.tree ul li:first-child::before {
    border: none;
}

.tree ul li:last-child::after {
    border: none;
}

/* Line from Parent to Children */
.tree ul::before {
    content: '';
    position: absolute;
    top: 0;
    left: 50%;
    border-left: 2px solid #007bff;
    height: 40px;
    width: 0;
    transform: translateX(-50%);
}

/* Node Styling */
.tree-node {
    border: 2px solid #007bff;
    padding: 10px;
    width: 150px;
    height: 120px;
    border-radius: 10px;
    background: #fff;
    text-align: center;
    box-shadow: 0 6px 15px rgba(0, 0, 0, 0.1);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    cursor: pointer;
    display: inline-block;
    position: relative;
}

.tree-node:hover {
    transform: scale(1.08);
    box-shadow: 0 12px 30px rgba(0, 0, 0, 0.2);
}

.node-content {
    margin-top: 5px;
}

.node-name {
    font-size: 0.85rem;
    font-weight: bold;
    color: #0056b3;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.node-email {
    font-size: 0.75rem;
    margin-top: 3px;
    color: #6c757d;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

/* Responsive Design */
@media (max-width: 768px) {
    .tree ul {
        flex-wrap: wrap;
    }

    .tree-node {
        width: 120px;
        height: 100px;
        padding: 8px;
    }

    .node-name {
        font-size: 0.75rem;
    }

    .node-email {
        font-size: 0.65rem;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    tooltipTriggerList.forEach(function (tooltipTriggerEl) {
        new bootstrap.Tooltip(tooltipTriggerEl);
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\user\ib-tree.blade.php ENDPATH**/ ?>