

<?php $__env->startSection('title', 'Deposit Funds'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-5" style="background: linear-gradient(135deg, #eef2f7, #ffffff);">
    <div class="row justify-content-center">
        <!-- Page Header -->
        <div class="col-lg-8 text-center mb-4">
            <h1 class="text-gradient fw-bold mb-2">
                <i class="fas fa-coins me-2"></i> Deposit Funds
            </h1>
            <p class="text-muted fs-6">Securely add funds to your account using our trusted payment gateways.</p>
        </div>
    </div>

    <!-- Deposit Form -->
    <div class="row justify-content-center">
        <div class="col-lg-6">
            <div class="card shadow border-0 rounded-4">
                <div class="card-header text-white text-center" style="background: linear-gradient(135deg, #007bff, #0056b3);">
                    <h4 class="m-0 fw-bold">
                        <i class="fas fa-wallet me-2"></i> Deposit Form
                    </h4>
                </div>
                <div class="card-body" style="background: linear-gradient(135deg, #ffffff, #f8f9fa);">
                    <form action="<?php echo e(route('wallet.processDeposit')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <!-- Amount Input -->
                        <div class="form-floating mb-4">
                            <input type="number" name="amount" id="amount" class="form-control shadow-sm" placeholder="Enter Amount" min="10" required>
                            <label for="amount">
                                <i class="fas fa-dollar-sign me-2"></i> Deposit Amount
                            </label>
                        </div>

                        <!-- Payment Gateway Selection -->
                        <div class="form-floating mb-4">
                            <select name="gateway_name" id="gateway_name" class="form-select shadow-sm" required>
                                <option value="" disabled selected>Select Payment Gateway</option>
                                <?php $__currentLoopData = $activeGateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($gateway->gateway_name); ?>"><?php echo e($gateway->gateway_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <label for="gateway_name">
                                <i class="fas fa-credit-card me-2"></i> Payment Gateway
                            </label>
                        </div>

                        <!-- Submit Button -->
                        <div class="text-center">
                            <button type="submit" class="btn btn-success shadow-sm px-5 py-2 rounded-pill">
                                <i class="fas fa-arrow-right me-2"></i> Proceed to Payment
                            </button>
                        </div>
                    </form>
                </div>
                <div class="card-footer text-center text-muted">
                    <small>Minimum deposit amount: <strong>$10</strong>. Please choose your payment gateway wisely.</small>
                </div>
            </div>
        </div>
    </div>

    <!-- Information Section -->
    <div class="row justify-content-center mt-5">
        <div class="col-lg-8">
            <div class="card shadow border-0 rounded-4">
                <div class="card-header text-white" style="background: linear-gradient(135deg, #28a745, #218838);">
                    <h5 class="m-0">
                        <i class="fas fa-info-circle me-2"></i> Why Deposit with Us?
                    </h5>
                </div>
                <div class="card-body">
                    <p class="text-muted mb-2"><i class="fas fa-shield-alt text-primary me-2"></i> Your funds are protected with our state-of-the-art security measures.</p>
                    <p class="text-muted mb-2"><i class="fas fa-clock text-primary me-2"></i> Fast processing times ensure your funds are available quickly.</p>
                    <p class="text-muted mb-0"><i class="fas fa-users text-primary me-2"></i> Trusted by thousands of users worldwide.</p>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
    .text-gradient {
        background: linear-gradient(to right, #ff7e5f, #feb47b);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
    }

    .card-header {
        background: linear-gradient(135deg, #007bff, #0056b3);
        color: #fff;
    }

    .btn-success {
        background: linear-gradient(135deg, #28a745, #218838);
        border: none;
    }

    .btn-success:hover {
        background: linear-gradient(135deg, #218838, #1e7e34);
        color: #fff;
    }

    .form-control,
    .form-select {
        border-radius: 12px;
        box-shadow: 0px 5px 15px rgba(0, 0, 0, 0.1);
    }

    .form-control:focus,
    .form-select:focus {
        box-shadow: 0px 8px 20px rgba(0, 123, 255, 0.25);
        border-color: #007bff;
    }

    .card-footer small {
        font-size: 0.9rem;
    }

    .text-muted {
        font-size: 0.95rem;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\forex-crm\resources\views\user\deposit.blade.php ENDPATH**/ ?>