<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\AdminDashboardController;
use App\Http\Controllers\UserDashboardController;
use App\Http\Controllers\WalletController;
use App\Http\Controllers\AdminTransactionController;
use App\Http\Controllers\UserProfileController;
use App\Http\Controllers\ReferralController;
use App\Http\Controllers\TradeController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\AdminSettingsController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\UserMT5Controller;
use App\Http\Controllers\AdminMT5Controller;
use App\Http\Controllers\AdminMT5APISettingsController;
use App\Http\Controllers\IBController;
use App\Http\Controllers\UserIBController;
use App\Http\Controllers\KYCController;
use App\Http\Controllers\AdminKycController;
use App\Http\Controllers\AdminWithdrawController;
use App\Http\Controllers\AdminDepositController;
use App\Http\Controllers\IBDashboardController;
use App\Http\Controllers\AdminIBReportController;
use App\Http\Controllers\UserIBReportController;
use App\Http\Controllers\Admin\IBCommissionLevelController;
use App\Http\Controllers\Admin\IBEarningsController;
use App\Http\Controllers\AdminSupportTicketController;
use App\Http\Controllers\SupportTicketController;
use App\Http\Controllers\MT5Controller;



// Home Route
Route::get('/', function () {
    return view('welcome');
});

// Authentication Routes
Auth::routes();


// Registration route
Route::get('register', [RegisterController::class, 'showRegistrationForm'])->name('register');
Route::post('register', [RegisterController::class, 'register']);

// Common Routes for All Authenticated Users
Route::middleware('auth')->group(function () {
    Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
    Route::get('/profile', [UserProfileController::class, 'show'])->name('profile.show');
    Route::post('/profile', [UserProfileController::class, 'update'])->name('profile.update');
    Route::get('/referrals', [ReferralController::class, 'index'])->name('referrals.index');
});

// Admin Dashboard Routes
Route::middleware(['auth', 'role:admin'])->prefix('admin')->name('admin.')->group(function () {
    // Dashboard
    Route::get('/dashboard', [AdminDashboardController::class, 'index'])->name('dashboard');

    // User Management
    Route::get('/users', [AdminDashboardController::class, 'manageUsers'])->name('users');
    Route::get('/users/edit/{id}', [AdminDashboardController::class, 'editUser'])->name('users.edit');
    Route::put('/users/{id}', [AdminDashboardController::class, 'updateUser'])->name('users.update');
    Route::delete('/users/{id}', [AdminDashboardController::class, 'deleteUser'])->name('users.delete');
    Route::post('/users/update-role', [AdminDashboardController::class, 'updateUserRole'])->name('users.updateRole');

    // Trades
    Route::get('/trades', [AdminDashboardController::class, 'viewTrades'])->name('trades');

    // Transactions
    Route::get('/transactions', [AdminTransactionController::class, 'index'])->name('transactions.index');
    Route::post('/transactions/{id}/approve', [AdminTransactionController::class, 'approve'])->name('transactions.approve');
    Route::post('/transactions/{id}/reject', [AdminTransactionController::class, 'reject'])->name('transactions.reject');
    Route::get('/transactions/export', [AdminTransactionController::class, 'exportTransactions'])->name('transactions.export');

    // Transfer Funds
    Route::get('/transfer-funds', [AdminDashboardController::class, 'showTransferFundsForm'])->name('transferFunds');
    Route::post('/transfer-funds', [AdminDashboardController::class, 'transferFundsToMT5'])->name('transferFunds.submit');

    // Activity Logs
    Route::get('/activity-logs', [AdminDashboardController::class, 'activityLogs'])->name('activity-logs');

    // Reports
    Route::get('/reports', [AdminDashboardController::class, 'viewReports'])->name('reports');

    // Settings
    Route::get('/settings', [AdminSettingsController::class, 'index'])->name('settings');
    Route::post('/settings', [AdminSettingsController::class, 'update'])->name('settings.update');

    // Role Management
    Route::get('/roles', [RoleController::class, 'index'])->name('roles.index');
    Route::get('/roles/create', [RoleController::class, 'create'])->name('roles.create');
    Route::post('/roles', [RoleController::class, 'store'])->name('roles.store');

    // Permission Management
    Route::get('/permissions', [PermissionController::class, 'index'])->name('permissions.index');
    Route::get('/permissions/create', [PermissionController::class, 'create'])->name('permissions.create');
    Route::post('/permissions', [PermissionController::class, 'store'])->name('permissions.store');

    // MT5 Settings (User, IP, etc.)
    Route::get('/mt5/setting', [AdminMT5Controller::class, 'viewMT5Settings'])->name('mt5.setting');
    // MT5 Settings Update
    Route::post('/mt5/setting/update', [AdminMT5Controller::class, 'updateMT5Settings'])->name('mt5.settings.update');



    Route::get('/admin/mt5/accounts', [AdminMT5Controller::class, 'listAccounts'])->name('admin.mt5.accounts');
    Route::get('/admin/mt5/trades', [AdminMT5Controller::class, 'viewAllTrades'])->name('admin.mt5.trades');
    Route::get('/admin/mt5/settings', [AdminMT5Controller::class, 'viewMT5Settings'])->name('admin.mt5.settings');
    Route::post('/admin/mt5/settings', [AdminMT5Controller::class, 'updateMT5Settings'])->name('admin.mt5.settings.update');

    // MT5 API Settings
    Route::get('/mt5-api-settings', [AdminMT5APISettingsController::class, 'index'])->name('mt5.api.setting');
    Route::post('/mt5-api-settings/update', [AdminMT5APISettingsController::class, 'update'])->name('mt5.api.setting.update');

    // MT5 Accounts and Trades
    Route::get('/mt5/accounts', [AdminMT5Controller::class, 'listAccounts'])->name('mt5.accounts');
    Route::get('/mt5/trades', [AdminMT5Controller::class, 'viewAllTrades'])->name('mt5.trades');

    // IB Management
    // IB Management
    Route::get('/ib-management', [IBController::class, 'index'])->name('ib.management');
    Route::get('/ib-tree/{id}', [IBController::class, 'showTree'])->name('ib.tree');
    Route::post('/ib-assign', [IBController::class, 'assignIB'])->name('ib.assign');
    Route::get('/ib/create', [IBController::class, 'create'])->name('ib.create');
    Route::post('/ib', [IBController::class, 'store'])->name('ib.store');
    Route::get('/admin/ib/export', [IBController::class, 'export'])->name('admin.ib.export');
    Route::post('/ib/update-status/{id}', [IBController::class, 'updateStatus'])->name('admin.ib.updateStatus');
    Route::delete('/ib/{id}', [IBController::class, 'delete'])->name('ib.delete');
    // Route::get('/ib/{id}/edit', [IBController::class, 'edit'])->name('ib.edit');
    // Route::put('/ib/{id}', [IBController::class, 'update'])->name('admin.ib.update'); // Add this line
    // IB Management
    Route::get('/ib/{id}/edit', [IBController::class, 'edit'])->name('ib.edit'); // Edit IB
    Route::put('/ib/{id}', [IBController::class, 'update'])->name('ib.update'); // Update IB (PUT request)



});

// User Dashboard Routes
Route::middleware(['auth', 'role:user'])->prefix('user')->name('user.')->group(function () {
    // Dashboard
    Route::get('/dashboard', [UserDashboardController::class, 'index'])->name('dashboard');

    // Trades
    Route::get('/trades', [TradeController::class, 'index'])->name('trades');
    Route::post('/trades/open', [TradeController::class, 'openTrade'])->name('trade.open');
    Route::post('/trades/close/{id}', [TradeController::class, 'closeTrade'])->name('trade.close');

    // Wallet Management
    Route::get('/wallet', [WalletController::class, 'index'])->name('wallet.index');
    Route::post('/wallet/deposit', [WalletController::class, 'deposit'])->name('wallet.deposit');
    Route::post('/wallet/withdraw', [WalletController::class, 'withdraw'])->name('wallet.withdraw');

    // Activity Logs
    Route::get('/activity-logs', [UserDashboardController::class, 'activityLogs'])->name('activity-logs');

    // Transfer Funds
    Route::get('/transfer-funds', [UserDashboardController::class, 'showTransferFunds'])->name('transferFunds');
    Route::post('/transfer-funds', [UserDashboardController::class, 'transferFunds'])->name('transferFunds.submit');

    // MT5 Account Management
    Route::get('/mt5/create-live', [UserDashboardController::class, 'showCreateLiveAccount'])->name('mt5.createLive');
    Route::post('/mt5/create-live', [UserDashboardController::class, 'createLiveAccount'])->name('mt5.createLive.submit');
    Route::get('/mt5/create-demo', [UserDashboardController::class, 'showCreateDemoAccount'])->name('mt5.createDemo');
    Route::post('/mt5/create-demo', [UserDashboardController::class, 'createDemoAccount'])->name('mt5.createDemo.submit');
    Route::get('/mt5/trades', [UserDashboardController::class, 'showTrades'])->name('mt5.trades');

    // IB Dashboard and Tree
    Route::get('/ib-dashboard', [UserIBController::class, 'ibDashboard'])->name('ib.dashboard');
    Route::get('/ib-tree', [UserIBController::class, 'viewIBTree'])->name('ib.tree');
});


// KYC Routes for Users
Route::middleware(['auth', 'role:user'])->prefix('user')->name('user.')->group(function () {
    Route::get('/kyc', [App\Http\Controllers\KycController::class, 'showKycForm'])->name('kyc.form');
    Route::post('/kyc', [App\Http\Controllers\KycController::class, 'submitKyc'])->name('kyc.submit');
});

// KYC Routes for Admin
Route::middleware(['auth', 'role:admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/kyc', [App\Http\Controllers\AdminKycController::class, 'index'])->name('kyc.index');
    Route::get('/kyc/{id}', [App\Http\Controllers\AdminKycController::class, 'show'])->name('kyc.show');
    Route::post('/kyc/{id}/approve', [App\Http\Controllers\AdminKycController::class, 'approve'])->name('kyc.approve');
    Route::post('/kyc/{id}/reject', [App\Http\Controllers\AdminKycController::class, 'reject'])->name('kyc.reject');
});

Route::get('/admin/kyc/export', [AdminKycController::class, 'exportCsv'])->name('admin.kyc.exportCsv');

// KYC Routes
Route::middleware(['auth'])->group(function () {
    Route::get('/kyc', [KycController::class, 'showKycForm'])->name('user.kyc'); // Show KYC form
    Route::post('/kyc/submit', [KycController::class, 'submitKyc'])->name('user.kyc.submit'); // Submit KYC
});

Route::get('/users/create', [AdminDashboardController::class, 'createUser'])->name('admin.users.create');

Route::middleware(['auth'])->group(function () {
    Route::get('/wallet', [WalletController::class, 'index'])->name('wallet.index');
    Route::post('/wallet/deposit', [WalletController::class, 'deposit'])->name('wallet.deposit');
    Route::post('/wallet/withdraw', [WalletController::class, 'withdraw'])->name('wallet.withdraw');
});

Route::middleware(['auth'])->group(function () {
    Route::get('/wallet', [WalletController::class, 'index'])->name('wallet.index');
    Route::post('/wallet/deposit', [WalletController::class, 'deposit'])->name('wallet.deposit');
    Route::post('/wallet/withdraw', [WalletController::class, 'withdraw'])->name('wallet.withdraw');
});

Route::middleware(['auth'])->group(function () {
    Route::get('/wallet', [WalletController::class, 'index'])->name('wallet.index');
    Route::post('/wallet/deposit', [WalletController::class, 'initiateDeposit'])->name('wallet.deposit');
    Route::get('/wallet/payment/redirect/{transactionId}', [WalletController::class, 'paymentGatewayRedirect'])->name('wallet.payment.redirect');
    Route::get('/wallet/payment/callback/{transactionId}', [WalletController::class, 'handlePaymentCallback'])->name('wallet.payment.callback');
});

Route::post('/stripe/webhook', [WalletController::class, 'handleStripeWebhook'])->name('stripe.webhook');
Route::middleware(['auth'])->group(function () {
    Route::get('/wallet', [WalletController::class, 'index'])->name('wallet.index');
    Route::post('/wallet/deposit', [WalletController::class, 'initiateDeposit'])->name('wallet.deposit');
    Route::get('/wallet/payment/redirect/{transactionId}', [WalletController::class, 'paymentGatewayRedirect'])->name('wallet.payment.redirect');
    Route::get('/wallet/payment/callback/{transactionId}', [WalletController::class, 'handlePaymentCallback'])->name('wallet.payment.callback');

    // Add routes for PayPal integration
    Route::get('/wallet/payment/paypal/{transactionId}', [WalletController::class, 'initiatePaypalPayment'])->name('wallet.payment.paypal');
    Route::get('/wallet/payment/paypal/callback', [WalletController::class, 'handlePaypalCallback'])->name('wallet.payment.paypal.callback');
});

// Deposit Process
Route::post('/wallet/deposit', [WalletController::class, 'processDeposit'])->name('wallet.deposit');

// Manual Payment Details
Route::get('/wallet/manual-payment/{transactionId}', [WalletController::class, 'manualPaymentDetails'])->name('wallet.manualPaymentDetails');

// Payment Callback
Route::post('/wallet/payment-callback/{transactionId}', [WalletController::class, 'handlePaymentCallback'])->name('wallet.paymentCallback');


// Withdrawal Management Route
Route::middleware(['auth'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/withdrawals', [AdminWithdrawController::class, 'index'])->name('withdrawals');
    Route::post('/withdrawals/{id}/approve', [AdminWithdrawController::class, 'approve'])->name('withdrawals.approve');
    Route::post('/withdrawals/{id}/reject', [AdminWithdrawController::class, 'reject'])->name('withdrawals.reject');
});

// Admin Deposits Management
Route::prefix('admin')->middleware('auth')->group(function () {
    Route::get('/deposits', [AdminDepositController::class, 'index'])->name('admin.deposits.index');
    Route::post('/deposits/{id}/approve', [AdminDepositController::class, 'approve'])->name('admin.deposits.approve');
    Route::post('/deposits/{id}/reject', [AdminDepositController::class, 'reject'])->name('admin.deposits.reject');
});

Route::get('/admin/transactions/{id}/view', [AdminTransactionController::class, 'view'])
    ->name('admin.transactions.view');

// Admin Routes
Route::middleware(['auth'])->group(function () {
    // Payment Gateway Settings Routes
    // Route::get('/admin/payment-gateways', [AdminDashboardController::class, 'paymentGatewaySettings'])->name('admin.payment-gateways');
    Route::put('/admin/payment-gateways/{id}', [AdminDashboardController::class, 'updatePaymentGatewaySettings'])->name('admin.payment-gateways.update');
});

// User Routes
Route::middleware(['auth'])->group(function () {
    Route::get('/user/deposit', [WalletController::class, 'deposit'])->name('user.deposit');
    Route::post('/user/process-deposit', [WalletController::class, 'processDeposit'])->name('user.process-deposit');
    Route::post('/webhook/stripe', [WalletController::class, 'handleStripeWebhook'])->name('webhook.stripe');
});

Route::middleware(['auth'])->group(function () {
    Route::get('/wallet', [WalletController::class, 'index'])->name('wallet.index');
    Route::get('/wallet/deposit', [WalletController::class, 'deposit'])->name('wallet.deposit');
    Route::post('/wallet/process-deposit', [WalletController::class, 'processDeposit'])->name('wallet.processDeposit');
    Route::get('/wallet/payment-callback/{transactionId}', [WalletController::class, 'handlePaymentCallback'])->name('wallet.payment.callback');
    Route::post('/wallet/initiate-withdraw', [WalletController::class, 'initiateWithdraw'])->name('wallet.initiateWithdraw'); // Add this line
});

Route::prefix('admin')->name('admin.')->middleware(['auth'])->group(function () {
    Route::get('/payment-gateways', [AdminDashboardController::class, 'paymentGatewaySettings'])->name('payment.gateways');
    Route::get('/payment-gateways/create', [AdminDashboardController::class, 'createPaymentGateway'])->name('payment-gateways.create');
    Route::post('payment-gateways/store', [AdminDashboardController::class, 'storePaymentGateway'])->name('payment-gateways.store');
    Route::put('/payment-gateways/{id}', [AdminDashboardController::class, 'updatePaymentGateway'])->name('payment-gateways.update');
    Route::delete('/payment-gateways/{id}', [AdminDashboardController::class, 'deletePaymentGateway'])->name('payment-gateways.delete');
});

// routes/web.php
Route::get('wallet/manual-payment/{transactionId}', [WalletController::class, 'manualPaymentDetails'])->name('wallet.manualPaymentDetails');
Route::post('/admin/payment-gateways/manual', [AdminDashboardController::class, 'storeManualPaymentGateway'])->name('admin.payment-gateways.storeManual');

Route::get('/admin/payment-gateways/manual/create', [AdminDashboardController::class, 'createManualPaymentGateway'])->name('admin.payment-gateways.createManual');

Route::post('admin/payment-gateways/storeManual', [AdminDashboardController::class, 'storeManualPaymentGateway'])->name('admin.payment-gateways.storeManual');

// Show the form to create a manual payment gateway
Route::get('admin/payment-gateways/createManual', [AdminDashboardController::class, 'createManualPaymentGateway'])->name('admin.payment-gateways.createManual');

// Store manual payment gateway
Route::post('admin/payment-gateways/storeManual', [AdminDashboardController::class, 'storeManualPaymentGateway'])->name('admin.payment-gateways.storeManual');

//emailsetting

Route::prefix('admin')->middleware('auth')->group(function () {
    Route::get('email-settings', [AdminDashboardController::class, 'showEmailSettings'])->name('admin.email-settings');
    Route::put('email-settings', [AdminDashboardController::class, 'updateEmailSettings'])->name('admin.email-settings.update');
});

//admin send
Route::get('admin/users/{id}/send-email', [AdminDashboardController::class, 'showSendEmailForm'])->name('admin.users.send-email');
Route::post('admin/users/{id}/send-email', [AdminDashboardController::class, 'sendEmailToUser'])->name('admin.users.send-email.send');

// Route to show the email form
Route::get('admin/users/{id}/send-email', [AdminDashboardController::class, 'showSendEmailForm'])
    ->name('admin.users.sendEmailForm');

// Route to send the email to a specific user
Route::post('admin/users/{id}/send-email', [AdminDashboardController::class, 'sendEmailToUser'])
    ->name('admin.users.sendEmail');

Route::put('admin/users/update/{id}', [AdminDashboardController::class, 'updateUser'])->name('admin.users.update');

Route::post('/admin/users/{id}/toggle-status', [AdminDashboardController::class, 'toggleUserStatus'])->name('admin.users.toggleStatus');


Route::get('/admin/users/create', [AdminDashboardController::class, 'createUser'])->name('admin.user.create');
Route::post('/admin/users/store', [AdminDashboardController::class, 'storeUser'])->name('admin.user.store');


Route::resource('admin/roles', RoleController::class);
Route::post('admin/roles/{id}/assign-users', [RoleController::class, 'assignUsers'])->name('admin.roles.assignUsers');
Route::get('admin/roles/{id}/users', [RoleController::class, 'showUsers'])->name('admin.roles.showUsers');


// Define the route for deleting a role
Route::delete('/admin/roles/{role}', [RoleController::class, 'destroy'])->name('admin.roles.delete');

// Define other role-related routes if they are not yet defined
Route::get('/admin/roles', [RoleController::class, 'index'])->name('admin.roles.index');
Route::get('/admin/roles/create', [RoleController::class, 'create'])->name('admin.roles.create');
Route::post('/admin/roles', [RoleController::class, 'store'])->name('admin.roles.store');
Route::get('/admin/roles/{role}/edit', [RoleController::class, 'edit'])->name('admin.roles.edit');
Route::put('/admin/roles/{role}', [RoleController::class, 'update'])->name('admin.roles.update');
Route::get('/admin/roles/{role}/show-users', [RoleController::class, 'showUsers'])->name('admin.roles.showUsers');

Route::post('admin/users/update-role', [RoleController::class, 'updateRole'])->name('admin.users.updateRole');

Route::delete('admin/roles/{roleId}/user/{userId}/remove', [RoleController::class, 'removeUserRole'])->name('admin.roles.removeUserRole');

Route::prefix('admin')->name('admin.')->middleware(['auth'])->group(function () {
    Route::resource('ib-commission-levels', 'App\Http\Controllers\Admin\IBCommissionLevelController');
});





Route::get('/admin/ib-earnings', [IBEarningsController::class, 'index'])->name('admin.ib.earnings');
Route::post('/admin/ib-earnings/update/{id}', [IBEarningsController::class, 'updateEarnings'])->name('admin.ib.earnings.update');
Route::get('/admin/ib-earnings/{id}', [IBEarningsController::class, 'show'])->name('admin.ib.earnings.show');




Route::middleware(['auth'])->group(function () {
    Route::get('/referral-earnings', [IBDashboardController::class, 'referralEarnings'])->name('user.referral.earnings');
});


Route::get('/ib-dashboard', [ReferralController::class, 'IBDashboardController'])->name('user.ib.dashboard');


Route::get('/ib-dashboard', [UserIBController::class, 'ibDashboard'])->name('user.ib.dashboard');


// User IB Reports
Route::middleware(['auth'])->group(function () {
    Route::get('user/ib-reports', [UserIBReportController::class, 'index'])->name('user.ib-reports');
    Route::post('user/ib-reports/withdraw', [UserIBReportController::class, 'requestWithdrawal'])->name('user.ib-reports.withdraw');
});

// Admin IB Reports
Route::middleware(['auth'])->group(function () {
    Route::get('/admin/ib-reports', [AdminIBReportController::class, 'index'])->name('admin.ib-reports.index');
    Route::get('/admin/ib-reports/{id}', [AdminIBReportController::class, 'show'])->name('admin.ib-reports.show');
    Route::post('/admin/ib-reports/{id}/approve', [AdminIBReportController::class, 'approveWithdrawal'])->name('admin.ib-reports.approve');
    Route::post('/admin/ib-reports/{id}/reject', [AdminIBReportController::class, 'rejectWithdrawal'])->name('admin.ib-reports.reject');
});


Route::middleware(['auth'])->group(function () {
    Route::get('/ib-reports', [UserIBReportController::class, 'index'])->name('user.ib.reports');
    // Add other user-specific IB report routes here
});



// User Support Tickets
Route::prefix('support')->name('user.support.')->middleware('auth')->group(function () {
    Route::get('/', [SupportTicketController::class, 'index'])->name('index');
    Route::get('/create', [SupportTicketController::class, 'create'])->name('create');
    Route::post('/', [SupportTicketController::class, 'store'])->name('store');
    Route::get('/{id}', [SupportTicketController::class, 'show'])->name('show');
    Route::post('/{id}/reply', [SupportTicketController::class, 'reply'])->name('reply');
});

// Admin Support Tickets
Route::prefix('admin')->name('admin.')->middleware(['auth', 'role:admin'])->group(function () {
    Route::get('/support', [AdminSupportTicketController::class, 'index'])->name('support.index');
    Route::get('/support/{id}', [AdminSupportTicketController::class, 'show'])->name('support.show');
    Route::post('/support/{id}/reply', [AdminSupportTicketController::class, 'reply'])->name('support.reply');
    Route::post('/support/{id}/status', [AdminSupportTicketController::class, 'updateStatus'])->name('support.updateStatus');
    Route::delete('/support/{id}', [AdminSupportTicketController::class, 'destroy'])->name('support.destroy');

    Route::post('admin/support/{ticket}/status', [AdminSupportTicketController::class, 'updateStatus'])
        ->name('admin.support.updateStatus');
});

Route::middleware(['auth', 'role:user'])->group(function () {
    Route::get('/user/activity-logs', [UserDashboardController::class, 'activityLogs'])->name('user.activity.logs');
});



Route::middleware('auth')->prefix('admin')->name('admin.')->group(function () {
    Route::post('mt5/create-account', [AdminMT5Controller::class, 'createAccount'])->name('mt5.createAccount');
});


Route::post('/mt5/create-account', [MT5Controller::class, 'createAccount']);
Route::get('/mt5/trades/{accountId}', [MT5Controller::class, 'getTrades']);

Route::post('/user/mt5/create-live-account', [UserMT5Controller::class, 'createLiveAccount'])->name('user.mt5.create-live-account');
Route::post('/user/mt5/create-demo-account', [UserMT5Controller::class, 'createDemoAccount'])->name('user.mt5.create-demo-account');

Route::post('/mt5/create-account', [MT5Controller::class, 'createAccount']);
Route::get('/mt5/trades/{accountId}', [MT5Controller::class, 'getTrades']);
Route::post('/mt5/transfer-funds', [MT5Controller::class, 'transferFunds']);
Route::get('/mt5/accounts', [MT5Controller::class, 'getAllAccounts']);
Route::get('/mt5/trades', [MT5Controller::class, 'getAllTrades']);

Route::post('/admin/transfer-funds', [AdminDashboardController::class, 'transferFundsToMT5'])->name('admin.transfer.funds');



Route::prefix('mt5')->group(function () {
    Route::post('create-account', [MT5Controller::class, 'createAccount']);
    Route::get('trades/{login}', [MT5Controller::class, 'getTrades']);
    Route::post('transfer-funds', [MT5Controller::class, 'transferFunds']);
});

Route::get('admin/mt5/create-account', [AdminMT5Controller::class, 'createAccount'])->name('admin.mt5.createAccount');
Route::get('admin/mt5/view-account/{login}', [AdminMT5Controller::class, 'viewAccount'])->name('admin.mt5.viewAccount');
Route::get('admin/mt5/edit-account/{login}', [AdminMT5Controller::class, 'editAccount'])->name('admin.mt5.editAccount');
Route::delete('admin/mt5/delete-account/{login}', [AdminMT5Controller::class, 'deleteAccount'])->name('admin.mt5.deleteAccount');


Route::get('/admin/user/{userId}/trades', [AdminDashboardController::class, 'viewTrades'])
    ->name('admin.view.trades');


// Referral Registration Handling
// Route::get('register', [RegisterController::class, 'showRegistrationForm'])->name('register');
//Route::get('/register', function (Illuminate\Http\Request $request) {
//  if ($request->has('ref')) {
//   session()->put('referrer_id', $request->get('ref'));
// }
return view('auth.register');
//});