@extends('layouts.app')

@section('content')
<div class="container-fluid px-4">
    <h1 class="mt-4 mb-4">Your Trades</h1>

    <!-- Filters and Search -->
    <div class="row mb-4">
        <div class="col-md-8">
            <form method="GET" action="{{ route('user.trades') }}" class="d-flex">
                <select name="status" class="form-select me-2">
                    <option value="">All Statuses</option>
                    <option value="open" {{ request('status') == 'open' ? 'selected' : '' }}>Open</option>
                    <option value="closed" {{ request('status') == 'closed' ? 'selected' : '' }}>Closed</option>
                </select>
                <input type="text" name="asset" class="form-control me-2" placeholder="Search by Asset" value="{{ request('asset') }}">
                <button type="submit" class="btn btn-primary">Filter</button>
            </form>
        </div>
    </div>

    <!-- Trades Table -->
    <div class="card shadow-sm border-0">
        <div class="card-header bg-dark text-white">
            <i class="fas fa-chart-line me-2"></i> Trades
        </div>
        <div class="card-body">
            <table class="table table-hover">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Asset</th>
                        <th>Status</th>
                        <th>Profit/Loss</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($trades as $trade)
                    <tr>
                        <td>{{ $trade->id }}</td>
                        <td>{{ $trade->asset }}</td>
                        <td>
                            <span class="badge bg-{{ $trade->status == 'open' ? 'success' : 'secondary' }}">
                                {{ ucfirst($trade->status) }}
                            </span>
                        </td>
                        <td class="{{ $trade->profit_loss >= 0 ? 'text-success' : 'text-danger' }}">
                            ${{ number_format($trade->profit_loss, 2) }}
                        </td>
                        <td>{{ $trade->created_at->format('d M Y') }}</td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="text-center">No trades found.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    <div class="mt-4">
        {{ $trades->links() }}
    </div>
</div>
@endsection
