@extends('layouts.app')

@section('title', 'View Ticket')

@section('content')
<div class="container-fluid py-5" style="background: linear-gradient(135deg, #d7e9f7, #f7faff);">
    <div class="row justify-content-center">
        <!-- Ticket Details -->
        <div class="col-lg-4 mb-4">
            <div class="card shadow border-0 rounded-4 h-100" style="background: linear-gradient(135deg, #f9fbfc, #e8f1f6);">
                <div class="card-header text-white text-center" style="background: linear-gradient(135deg, #007bff, #0056b3);">
                    <h5 class="m-0">
                        <i class="fas fa-info-circle me-2"></i> Ticket Details
                    </h5>
                </div>
                <div class="card-body">
                    <p><strong>Ticket ID:</strong> <span class="text-primary">#{{ $ticket->id }}</span></p>
                    <p><strong>Subject:</strong> <span class="text-dark">{{ $ticket->subject }}</span></p>
                    <p>
                        <strong>Status:</strong>
                        <span class="badge 
                            @if($ticket->status == 'open') bg-gradient-primary 
                            @elseif($ticket->status == 'in_progress') bg-gradient-warning text-dark 
                            @elseif($ticket->status == 'completed') bg-gradient-success 
                            @elseif($ticket->status == 'closed') bg-gradient-danger 
                            @endif">
                            {{ ucfirst(str_replace('_', ' ', $ticket->status)) }}
                        </span>
                    </p>
                    <p>
                        <strong>Submitted By:</strong> 
                        <span class="text-primary">{{ $ticket->user->name }}</span> 
                        <small class="text-muted">({{ $ticket->user->email }})</small>
                    </p>
                    <p><strong>Description:</strong></p>
                    <div class="p-3 rounded-3 border text-secondary shadow-sm" style="background: linear-gradient(135deg, #ffffff, #f0f4f9);">
                        {{ $ticket->description }}
                    </div>
                    <p class="mt-3"><strong>Attachments:</strong></p>
                    @if ($ticket->attachments->isNotEmpty())
                        <ul class="list-unstyled">
                            @foreach ($ticket->attachments as $attachment)
                                <li>
                                    <a href="{{ asset('storage/' . $attachment->path) }}" target="_blank" class="text-primary">
                                        <i class="fas fa-paperclip me-2"></i>{{ $attachment->filename }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    @else
                        <p class="text-muted">No attachments uploaded.</p>
                    @endif
                </div>
            </div>
        </div>

        <!-- Replies Section -->
        <div class="col-lg-8 mb-4">
            <div class="card shadow border-0 rounded-4">
                <div class="card-header text-white text-center" style="background: linear-gradient(135deg, #28a745, #1c7c28);">
                    <h5 class="m-0">
                        <i class="fas fa-comments me-2"></i> Replies
                    </h5>
                </div>
                <div class="card-body" style="background: linear-gradient(135deg, #f7f8fa, #e9eff4);">
                    @forelse($ticket->replies as $reply)
                        <div class="card mb-3 border-0 shadow-sm" style="background: linear-gradient(135deg, #ffffff, #f2f7fa);">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <strong class="{{ $reply->user ? 'text-primary' : 'text-danger' }}">{{ $reply->user ? $reply->user->name : 'Admin' }}</strong>
                                    <span class="text-muted small">{{ $reply->created_at->format('d M Y, H:i') }}</span>
                                </div>
                                <p class="mb-0 text-secondary">{{ $reply->message }}</p>
                            </div>
                        </div>
                    @empty
                        <div class="alert alert-info text-center mb-0">
                            <i class="fas fa-info-circle me-2"></i> No replies yet.
                        </div>
                    @endforelse
                </div>
            </div>

            <!-- Reply Form -->
            <div class="card shadow border-0 rounded-4 mt-4">
                <div class="card-header text-white text-center" style="background: linear-gradient(135deg, #ff5722, #d84315);">
                    <h5 class="m-0">
                        <i class="fas fa-reply me-2"></i> Send a Reply
                    </h5>
                </div>
                <div class="card-body" style="background: linear-gradient(135deg, #fff4e6, #fffdf7);">
                    <form method="POST" action="{{ route('user.support.reply', $ticket->id) }}" enctype="multipart/form-data">
                        @csrf
                        <div class="form-floating mb-3">
                            <textarea name="message" class="form-control shadow-sm" id="floatingReply" style="height: 120px;" placeholder="Type your reply here..." required></textarea>
                            <label for="floatingReply">Type your reply here...</label>
                        </div>
                        <div class="mb-3">
                            <label for="attachment" class="form-label">Upload Attachments</label>
                            <input type="file" name="attachments[]" id="attachment" class="form-control" multiple>
                        </div>
                        <div class="text-end">
                            <button type="submit" class="btn btn-warning shadow-sm px-4 rounded-pill text-white">
                                <i class="fas fa-paper-plane me-2"></i> Send Reply
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* General Layout */
.container-fluid {
    max-width: 1400px;
}

/* Card Styles */
.card {
    border-radius: 15px;
}
.card-header {
    font-size: 1.3rem;
    font-weight: bold;
    text-transform: capitalize;
}

/* Badge Styles */
.badge {
    font-size: 0.9rem;
    padding: 8px 15px;
    font-weight: 600;
    text-transform: capitalize;
    border-radius: 12px;
}

/* Buttons */
.btn-warning {
    background: linear-gradient(135deg, #ff9800, #fb8c00);
    border: none;
    transition: all 0.3s ease-in-out;
}
.btn-warning:hover {
    background: linear-gradient(135deg, #fb8c00, #ef6c00);
    color: #fff;
}

/* Reply Styles */
textarea {
    resize: none;
    border-radius: 12px;
}
.card-body p {
    font-size: 1rem;
}

/* Responsive Design */
@media (max-width: 768px) {
    .btn-warning {
        font-size: 0.9rem;
        padding: 8px 15px;
    }
}
</style>
@endsection
