@extends('layouts.admin')

@section('content')
<div class="container-fluid py-4">

    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="text-primary fw-bold"><i class="fas fa-money-bill-wave me-2"></i>Manage Withdrawals</h2>
        <button class="btn btn-outline-primary shadow-sm" onclick="window.location.href='{{ route('admin.dashboard') }}'">
            <i class="fas fa-arrow-left"></i> Back to Dashboard
        </button>
    </div>

    <!-- Success Message -->
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <!-- Withdrawal Statistics -->
    <div class="row mb-4">
        <div class="col-md-4 mb-3">
            <div class="card border-light shadow-sm h-100">
                <div class="card-body d-flex flex-column justify-content-between">
                    <h5 class="card-title text-muted">Total Pending Withdrawals</h5>
                    <h3 class="text-warning fw-bold">{{ $withdrawals->count() }}</h3>
                    <i class="fas fa-hourglass-half fa-3x align-self-end text-warning-50"></i>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-3">
            <div class="card border-light shadow-sm h-100">
                <div class="card-body d-flex flex-column justify-content-between">
                    <h5 class="card-title text-muted">Total Approved Withdrawals</h5>
                    <h3 class="text-success fw-bold">{{ $approvedWithdrawalsCount }}</h3>
                    <i class="fas fa-check-circle fa-3x align-self-end text-success-50"></i>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-3">
            <div class="card border-light shadow-sm h-100">
                <div class="card-body d-flex flex-column justify-content-between">
                    <h5 class="card-title text-muted">Total Rejected Withdrawals</h5>
                    <h3 class="text-danger fw-bold">{{ $rejectedWithdrawalsCount }}</h3>
                    <i class="fas fa-times-circle fa-3x align-self-end text-danger-50"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter Section -->
    <div class="card shadow-sm border-light mb-4">
        <div class="card-header bg-primary text-white">
            <i class="fas fa-filter me-2"></i> Filters
        </div>
        <div class="card-body">
            <form id="filterForm" class="row gy-2 gx-3 align-items-center">
                <div class="col-md-3">
                    <input type="text" class="form-control" id="userNameFilter" placeholder="Search by User Name">
                </div>
                <div class="col-md-3">
                    <select class="form-select" id="statusFilter">
                        <option value="">Filter by Status</option>
                        <option value="pending">Pending</option>
                        <option value="approved">Approved</option>
                        <option value="rejected">Rejected</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <input type="text" class="form-control date-range-filter" id="dateRangeFilter" placeholder="Filter by Date Range">
                </div>
                <div class="col-md-2">
                    <button type="button" class="btn btn-primary w-100" id="applyFilters">Apply Filters</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Pending Withdrawals Table -->
    @if($withdrawals->isEmpty())
        <div class="alert alert-info shadow-sm">No pending withdrawal requests at the moment.</div>
    @else
        <div class="card shadow-lg border-light">
            <div class="card-header bg-primary text-white fw-bold">
                <i class="fas fa-hourglass-half me-2"></i> Pending Withdrawals
            </div>
            <div class="card-body p-4">
                <form id="batchProcessForm" action="" method="POST">
                    @csrf
                    <table class="table table-hover table-bordered align-middle">
                        <thead class="table-dark">
                            <tr>
                                <th><input type="checkbox" id="selectAll"></th>
                                <th>#</th>
                                <th>User</th>
                                <th>Amount ($)</th>
                                <th>Payment Method</th>
                                <th>Status</th>
                                <th>Date Requested</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($withdrawals as $withdrawal)
                                <tr>
                                    <td><input type="checkbox" class="withdrawal-checkbox" value="{{ $withdrawal->id }}"></td>
                                    <td>{{ $withdrawal->id }}</td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="me-3">
                                                <img src="{{ $withdrawal->user->profile_photo_url ?? asset('images/default-user.png') }}" alt="User Photo" class="rounded-circle" width="40" height="40">
                                            </div>
                                            <div>
                                                <strong>{{ $withdrawal->user->name }}</strong>
                                                <br>
                                                <small class="text-muted">{{ $withdrawal->user->email }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>${{ number_format($withdrawal->amount, 2) }}</td>
                                    <td>{{ ucfirst($withdrawal->payment_gateway) }}</td>
                                    <td>
                                        <span class="badge bg-warning">{{ ucfirst($withdrawal->status) }}</span>
                                    </td>
                                    <td>{{ $withdrawal->created_at->format('d M Y, h:i A') }}</td>
                                    <td class="d-flex gap-2">
                                        @if($withdrawal->status == 'pending')
                                            <form action="{{ route('admin.withdrawals.approve', $withdrawal->id) }}" method="POST" class="approve-form">
                                                @csrf
                                                <button type="submit" class="btn btn-success btn-sm" data-bs-toggle="tooltip" title="Approve Withdrawal">
                                                    <i class="fas fa-check-circle"></i>
                                                </button>
                                            </form>
                                            <form action="{{ route('admin.withdrawals.reject', $withdrawal->id) }}" method="POST" class="reject-form">
                                                @csrf
                                                <button type="submit" class="btn btn-danger btn-sm" data-bs-toggle="tooltip" title="Reject Withdrawal">
                                                    <i class="fas fa-times-circle"></i>
                                                </button>
                                            </form>
                                        @else
                                            <span class="text-muted">Processed</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <div>
                            <button type="submit" class="btn btn-success" id="batchApprove" disabled>Approve Selected</button>
                            <button type="submit" class="btn btn-danger" id="batchReject" disabled>Reject Selected</button>
                        </div>
                        <button id="downloadCSV" class="btn btn-outline-secondary btn-sm shadow-sm">
                            <i class="fas fa-file-download me-1"></i> Download CSV
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif
</div>

<!-- Tooltip Initialization -->
<script>
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });

    // Confirm before approve/reject
    document.querySelectorAll('.approve-form').forEach(form => {
        form.addEventListener('submit', function (e) {
            if (!confirm('Are you sure you want to approve this withdrawal request?')) {
                e.preventDefault();
            }
        });
    });

    document.querySelectorAll('.reject-form').forEach(form => {
        form.addEventListener('submit', function (e) {
            if (!confirm('Are you sure you want to reject this withdrawal request?')) {
                e.preventDefault();
            }
        });
    });

    // Select All Functionality
    document.getElementById('selectAll').addEventListener('change', function () {
        let checked = this.checked;
        document.querySelectorAll('.withdrawal-checkbox').forEach(checkbox => {
            checkbox.checked = checked;
        });
        toggleBatchButtons();
    });

    document.querySelectorAll('.withdrawal-checkbox').forEach(checkbox => {
        checkbox.addEventListener('change', toggleBatchButtons);
    });

    function toggleBatchButtons() {
        const checked = document.querySelectorAll('.withdrawal-checkbox:checked').length > 0;
        document.getElementById('batchApprove').disabled = !checked;
        document.getElementById('batchReject').disabled = !checked;
    }

    // Download Pending Withdrawals as CSV
    document.getElementById('downloadCSV').addEventListener('click', function () {
        let csvContent = "data:text/csv;charset=utf-8,ID,User,Amount,Payment Method,Status,Date Requested\n";
        document.querySelectorAll('tbody tr').forEach(function (row) {
            let rowData = [];
            row.querySelectorAll('td').forEach(function (cell) {
                rowData.push(cell.textContent.trim());
            });
            csvContent += rowData.join(",") + "\n";
        });

        let link = document.createElement("a");
        link.setAttribute("href", encodeURI(csvContent));
        link.setAttribute("download", "pending_withdrawals.csv");
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
    });

    // Filter Withdrawals
    document.getElementById('applyFilters').addEventListener('click', function () {
        // Implement filter logic here or apply it using AJAX
    });
</script>
@endsection
