@extends('layouts.admin')

@section('title', 'Update Role')

@section('content')
<div class="container-fluid px-4">
    <h2 class="mt-4 mb-4 text-primary text-center"><i class="fas fa-user-tag me-2"></i> Update Role</h2>

    <div class="card shadow-lg border-0 mb-5 rounded">
        <div class="card-header bg-gradient-primary text-white d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="fas fa-edit me-2"></i> Edit Role: {{ ucfirst($role->name) }}</h5>
            <a href="{{ route('admin.roles.index') }}" class="btn btn-light btn-sm shadow-sm">
                <i class="fas fa-arrow-left me-2"></i> Back to Roles List
            </a>
        </div>

        <div class="card-body">
            <form action="{{ route('admin.roles.update', $role->id) }}" method="POST">
                @csrf
                @method('PUT')

                <!-- Role Name -->
                <div class="form-group mb-4">
                    <label for="name" class="form-label fw-bold"><i class="fas fa-user-tag me-2"></i>Role Name</label>
                    <input type="text" name="name" id="name" class="form-control form-control-lg shadow-sm" value="{{ old('name', $role->name) }}" required>
                </div>

                <!-- Permissions -->
                <div class="form-group mb-4">
                    <label for="permissions" class="form-label fw-bold"><i class="fas fa-unlock-alt me-2"></i>Permissions</label>
                    <div class="form-check form-check-inline">
                        @foreach($permissions as $permission)
                            <div class="form-check mb-2">
                                <input type="checkbox" class="form-check-input shadow-sm" name="permissions[]" id="permission-{{ $permission->id }}" value="{{ $permission->id }}" {{ $role->permissions->contains($permission->id) ? 'checked' : '' }}>
                                <label class="form-check-label" for="permission-{{ $permission->id }}">
                                    {{ ucfirst($permission->name) }}
                                </label>
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- Save Changes Button -->
                <div class="text-end">
                    <button type="submit" class="btn btn-primary btn-lg shadow-sm">
                        <i class="fas fa-save me-2"></i> Save Changes
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Users Assigned to Role Section -->
    <div class="card shadow-lg border-0 rounded">
        <div class="card-header bg-gradient-primary text-white d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="fas fa-users me-2"></i> Users Assigned to Role: {{ ucfirst($role->name) }}</h5>
        </div>
        <div class="card-body">
            @if($role->users->isEmpty())
                <div class="alert alert-info text-center">
                    <i class="fas fa-info-circle"></i> No users assigned to this role.
                </div>
            @else
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-primary">
                            <tr class="text-center">
                                <th>#</th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody class="border-top">
                            @foreach($role->users as $user)
                                <tr class="text-center">
                                    <td>{{ $user->id }}</td>
                                    <td>{{ $user->name }}</td>
                                    <td>{{ $user->email }}</td>
                                    <td>
                                        <!-- Remove Role Button -->
                                        <form action="{{ route('admin.roles.removeUserRole', [$role->id, $user->id]) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to remove this role from the user?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger shadow-sm" title="Remove this role from the user">
                                                <i class="fas fa-user-minus"></i> Remove Role
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @endif
        </div>
    </div>
</div>

@endsection

<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Add tooltip to each role removal button
        document.querySelectorAll('button.btn-danger').forEach(button => {
            button.setAttribute('title', 'Remove this role from the user');
        });
    });
</script>
