@extends('layouts.admin') <!-- Use the admin layout -->

@section('content')
<div class="container-fluid px-4">

    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mt-4 mb-4">
        <h1 class="text-primary fw-bold">Manage Transactions</h1>
        <div>
          <!--  <a href="{{ route('admin.transactions.export') }}" class="btn btn-outline-success btn-lg shadow-sm">
                <i class="fas fa-file-excel"></i> Export to Excel
            </a>  -->
        </div>
    </div>  

    <!-- Transactions Summary Section -->
    <div class="row mb-4">
        <div class="col-md-4 mb-3">
            <div class="card border-light shadow-sm h-100" style="background-color: #3498db; color: #ffffff;">
                <div class="card-body d-flex flex-column justify-content-between">
                    <h5 class="card-title text-white">Total Pending Transactions</h5>
                    <h3 class="fw-bold">{{ $pendingTransactionsCount ?? 0 }}</h3>
                    <i class="fas fa-hourglass-half fa-3x align-self-end text-white-50"></i>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-3">
            <div class="card border-light shadow-sm h-100" style="background-color: #28a745; color: #ffffff;">
                <div class="card-body d-flex flex-column justify-content-between">
                    <h5 class="card-title text-white">Total Approved Transactions</h5>
                    <h3 class="fw-bold">{{ $approvedTransactionsCount ?? 0 }}</h3>
                    <i class="fas fa-check-circle fa-3x align-self-end text-white-50"></i>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-3">
            <div class="card border-light shadow-sm h-100" style="background-color: #e74c3c; color: #ffffff;">
                <div class="card-body d-flex flex-column justify-content-between">
                    <h5 class="card-title text-white">Total Rejected Transactions</h5>
                    <h3 class="fw-bold">{{ $rejectedTransactionsCount ?? 0 }}</h3>
                    <i class="fas fa-times-circle fa-3x align-self-end text-white-50"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Search and Filters Section -->
    <div class="card shadow mb-4 border-light">
        <div class="card-body">
            <form action="{{ route('admin.transactions.index') }}" method="GET">
                <div class="row g-3">
                    <div class="col-lg-4">
                        <input type="text" name="search" class="form-control" placeholder="Search by user name or type" value="{{ request('search') }}">
                    </div>
                    <div class="col-lg-3">
                        <select name="filter" class="form-select">
                            <option value="">All Transactions</option>
                            <option value="deposit" {{ request('filter') == 'deposit' ? 'selected' : '' }}>Deposits</option>
                            <option value="withdrawal" {{ request('filter') == 'withdrawal' ? 'selected' : '' }}>Withdrawals</option>
                        </select>
                    </div>
                    <div class="col-lg-3">
                        <div class="input-group">
                            <input type="date" name="start_date" class="form-control" value="{{ request('start_date') }}" placeholder="Start Date">
                            <input type="date" name="end_date" class="form-control" value="{{ request('end_date') }}" placeholder="End Date">
                        </div>
                    </div>
                    <div class="col-lg-2 text-end">
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-filter"></i> Apply Filters
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Transactions Table Section -->
    <div class="card shadow-sm border-light">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover table-bordered align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th>#</th>
                            <th>User</th>
                            <th>Type</th>
                            <th>Amount</th>
                            <th>Status</th>
                            <th>Date</th>
                            <th class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($transactions as $transaction)
                            <tr>
                                <td>{{ $transaction->id }}</td>
                                <td>{{ $transaction->user->name }}</td>
                                <td>
                                    <span class="badge rounded-pill bg-{{ $transaction->type === 'deposit' ? 'success' : 'warning' }}">
                                        {{ ucfirst($transaction->type) }}
                                    </span>
                                </td>
                                <td>${{ number_format($transaction->amount, 2) }}</td>
                                <td>
                                    <span class="badge rounded-pill bg-{{ $transaction->status === 'approved' ? 'success' : ($transaction->status === 'rejected' ? 'danger' : 'warning') }}">
                                        {{ ucfirst($transaction->status) }}
                                    </span>
                                </td>
                                <td>{{ $transaction->created_at->format('d M Y, h:i A') }}</td>
                                <td class="text-center">
                                    @if($transaction->status == 'pending')
                                        <form action="{{ route('admin.transactions.approve', $transaction->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            <button type="submit" class="btn btn-outline-success btn-sm" data-bs-toggle="tooltip" title="Approve Transaction">
                                                <i class="fas fa-check-circle"></i>
                                            </button>
                                        </form>
                                        <form action="{{ route('admin.transactions.reject', $transaction->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            <button type="submit" class="btn btn-outline-danger btn-sm" data-bs-toggle="tooltip" title="Reject Transaction">
                                                <i class="fas fa-times-circle"></i>
                                            </button>
                                        </form>
                                    @else
                                        <span class="badge bg-secondary">Processed</span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center text-muted">No transactions found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-end mt-4">
                {{ $transactions->links() }}
            </div>
        </div>
    </div>

</div>

<!-- JavaScript -->
<script>
    // Tooltip Initialization
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
</script>
@endsection
