@extends('layouts.admin')

@section('content')
<div class="container mt-4">
    <h2 class="mb-4">MT5 Trades</h2>

    @if (session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    @if (isset($trades) && count($trades) > 0)
        <div class="table-responsive">
            <table class="table table-striped table-bordered">
                <thead class="table-dark">
                    <tr>
                        <th>Ticket</th>
                        <th>Login</th>
                        <th>Symbol</th>
                        <th>Type</th>
                        <th>Volume</th>
                        <th>Profit</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($trades as $trade)
                        <tr>
                            <td>{{ $trade['ticket'] }}</td>
                            <td>{{ $trade['login'] }}</td>
                            <td>{{ $trade['symbol'] }}</td>
                            <td>
                                @if($trade['type'] === 'buy')
                                    <span class="badge bg-success">Buy</span>
                                @elseif($trade['type'] === 'sell')
                                    <span class="badge bg-danger">Sell</span>
                                @else
                                    <span class="badge bg-secondary">Other</span>
                                @endif
                            </td>
                            <td>{{ number_format($trade['volume'], 2) }}</td>
                            <td>{{ number_format($trade['profit'], 2) }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    @else
        <div class="alert alert-warning">No trades found.</div>
    @endif
</div>
@endsection
