@extends('layouts.admin')

@section('title', 'Send Email to User')

@section('content')
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mt-4 mb-4">
        <h1 class="h3 fw-bold text-primary">
            <i class="fas fa-envelope me-2"></i> Send Email to {{ $user->name }}
        </h1>
        <a href="{{ route('admin.users') }}" class="btn btn-outline-primary btn-sm shadow-sm">
            <i class="fas fa-arrow-left"></i> Back to Users
        </a>
    </div>

    <!-- Send Email Form -->
    <div class="card shadow-lg border-0 mb-5">
        <div class="card-header bg-gradient-primary text-white d-flex align-items-center">
            <h4 class="mb-0"><i class="fas fa-envelope-open-text me-2"></i> Compose Email</h4>
        </div>
        <div class="card-body p-4">
            <form action="{{ route('admin.users.sendEmail', $user->id) }}" method="POST" class="email-form bg-white p-5 rounded shadow-sm border border-light position-relative">
                @csrf

                <!-- Quick Email Templates Dropdown -->
                <div class="mb-4">
                    <label class="form-label fw-bold">Choose Email Template <span class="text-muted">(Optional)</span></label>
                    <select id="emailTemplate" class="form-select form-select-lg shadow-sm">
                        <option value="" disabled selected>Choose a template...</option>
                        <option value="welcome">Welcome Email</option>
                        <option value="signup">Signup Confirmation</option>
                        <option value="transaction">Transaction Notification</option>
                        <option value="passwordReset">Password Reset Instructions</option>
                        <option value="custom">Custom Message</option>
                    </select>
                </div>

                <!-- Subject -->
                <div class="mb-4">
                    <label class="form-label fw-bold">Subject</label>
                    <input type="text" name="subject" id="subject" class="form-control form-control-lg shadow-sm" placeholder="Enter Email Subject" required>
                </div>

                <!-- Message -->
                <div class="mb-4">
                    <label class="form-label fw-bold">Message</label>
                    <textarea name="message" id="message" class="form-control form-control-lg shadow-sm" rows="8" placeholder="Enter your message here..." required></textarea>
                </div>

                <!-- Additional Options -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="form-check form-switch">
                            <input type="checkbox" class="form-check-input shadow-sm" id="attachPDF" name="attachPDF">
                            <label class="form-check-label fw-bold" for="attachPDF">
                                Attach account summary as PDF
                            </label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-check form-switch">
                            <input type="checkbox" class="form-check-input shadow-sm" id="ccAdmin" name="ccAdmin">
                            <label class="form-check-label fw-bold" for="ccAdmin">
                                Send a copy to admin
                            </label>
                        </div>
                    </div>
                </div>

                <!-- Rich Text Editor for Message -->
                <div class="mb-4">
                    <label class="form-label fw-bold">Rich Text Editor <span class="text-muted">(Optional)</span></label>
                    <div id="richTextEditor" class="border p-3 rounded shadow-sm" contenteditable="true" style="height: 200px; background-color: #f9f9f9;"></div>
                    <button type="button" class="btn btn-sm btn-secondary mt-2" onclick="copyRichText()">
                        <i class="fas fa-copy"></i> Copy to Message
                    </button>
                </div>

                <!-- Preview Button -->
                <div class="mb-4 text-end">
                    <button type="button" class="btn btn-info btn-lg shadow" onclick="previewEmail()">
                        <i class="fas fa-eye"></i> Preview Email
                    </button>
                </div>

                <!-- Submit Button -->
                <div class="text-end">
                    <button type="submit" class="btn btn-gradient-primary btn-lg shadow">
                        <i class="fas fa-paper-plane"></i> Send Email
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Email Preview Modal -->
    <div class="modal fade" id="emailPreviewModal" tabindex="-1" aria-labelledby="emailPreviewModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-gradient-primary text-white">
                    <h5 class="modal-title" id="emailPreviewModalLabel"><i class="fas fa-eye me-2"></i> Email Preview</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <h4 id="previewSubject" class="fw-bold text-primary"></h4>
                    <hr>
                    <p id="previewMessage" class="lead"></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><i class="fas fa-times"></i> Close</button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const emailTemplate = document.getElementById('emailTemplate');
        const subjectField = document.getElementById('subject');
        const messageField = document.getElementById('message');

        emailTemplate.addEventListener('change', function() {
            switch (this.value) {
                case 'welcome':
                    subjectField.value = 'Welcome to Our Platform!';
                    messageField.value = `Dear {{ $user->name }},\n\nWelcome to our platform! We are excited to have you on board and look forward to supporting you in your trading journey.\n\nBest regards,\nThe Team`;
                    break;
                case 'signup':
                    subjectField.value = 'Your Signup is Complete';
                    messageField.value = `Dear {{ $user->name }},\n\nThank you for signing up! You can now access all the features of our platform and start exploring.\n\nBest regards,\nThe Team`;
                    break;
                case 'transaction':
                    subjectField.value = 'Transaction Update';
                    messageField.value = `Dear {{ $user->name }},\n\nWe wanted to inform you that a recent transaction has been successfully processed. Please log in to your account to see the details.\n\nBest regards,\nThe Team`;
                    break;
                case 'passwordReset':
                    subjectField.value = 'Password Reset Instructions';
                    messageField.value = `Dear {{ $user->name }},\n\nWe have received a request to reset your password. Please click the link below to set a new password:\n\n[Password Reset Link]\n\nIf you did not request a password reset, please ignore this email.\n\nBest regards,\nThe Team`;
                    break;
                case 'custom':
                    subjectField.value = '';
                    messageField.value = '';
                    break;
                default:
                    subjectField.value = '';
                    messageField.value = '';
            }
        });
    });

    function previewEmail() {
        const subject = document.getElementById('subject').value;
        const message = document.getElementById('message').value;

        document.getElementById('previewSubject').innerText = subject;
        document.getElementById('previewMessage').innerText = message;

        const emailPreviewModal = new bootstrap.Modal(document.getElementById('emailPreviewModal'));
        emailPreviewModal.show();
    }

    function copyRichText() {
        const richTextEditorContent = document.getElementById('richTextEditor').innerHTML;
        document.getElementById('message').value = richTextEditorContent;
    }
</script>
@endsection
