@extends('layouts.admin')

@section('title', 'Edit IB')

@section('content')
<div class="container-fluid px-4">
    <div class="row align-items-center mb-4">
        <div class="col-12">
            <h2 class="mt-4 text-center text-primary fw-bold border-bottom pb-3">
                <i class="fas fa-user-edit me-2"></i> Edit IB
            </h2>
        </div>
    </div>

    <form action="{{ route('admin.ib.update', $ib->id) }}" method="POST" class="needs-validation" novalidate>
        @csrf
        @method('PUT')

        <div class="card shadow-lg border-0 mb-5 rounded-4">
            <div class="card-header bg-gradient-primary text-white d-flex justify-content-between align-items-center rounded-top">
                <strong><i class="fas fa-user-cog me-2"></i> IB Details</strong>
                <a href="{{ route('admin.ib.management') }}" class="btn btn-light btn-sm shadow-sm rounded-pill">
                    <i class="fas fa-arrow-left me-2"></i> Back to List
                </a>
            </div>
            <div class="card-body bg-light p-4">
                <div class="row g-3 mb-4">
                    <div class="col-md-6">
                        <label for="name" class="form-label fw-bold">IB Name <span class="text-danger">*</span></label>
                        <input type="text" name="name" id="name" class="form-control shadow-sm rounded-pill" value="{{ old('name', $ib->name) }}" required>
                        <div class="invalid-feedback">
                            Please provide the IB name.
                        </div>
                    </div>

                    <div class="col-md-6">
                        <label for="email" class="form-label fw-bold">Email Address <span class="text-danger">*</span></label>
                        <input type="email" name="email" id="email" class="form-control shadow-sm rounded-pill" value="{{ old('email', $ib->email) }}" required>
                        <div class="invalid-feedback">
                            Please provide a valid email address.
                        </div>
                    </div>
                </div>

                <div class="row g-3 mb-4">
                    <div class="col-md-6">
                        <label for="phone" class="form-label fw-bold">Phone Number</label>
                        <input type="text" name="phone" id="phone" class="form-control shadow-sm rounded-pill" value="{{ old('phone', $ib->phone) }}" placeholder="Optional">
                        <div class="invalid-feedback">
                            Please provide a valid phone number.
                        </div>
                    </div>

                    <div class="col-md-6">
                        <label for="address" class="form-label fw-bold">Address</label>
                        <input type="text" name="address" id="address" class="form-control shadow-sm rounded-pill" value="{{ old('address', $ib->address) }}" placeholder="Optional">
                        <div class="invalid-feedback">
                            Please provide a valid address.
                        </div>
                    </div>
                </div>

                <div class="row g-3 mb-4">
                    <div class="col-md-6">
                        <div class="form-check form-switch">
                            <input type="hidden" name="is_active" value="0">
                            <input type="checkbox" class="form-check-input shadow-sm" name="is_active" id="isActiveToggle" value="1" {{ $ib->is_active ? 'checked' : '' }}>
                            <label class="form-check-label fw-bold" for="isActiveToggle" id="isActiveLabel">{{ $ib->is_active ? 'Active' : 'Inactive' }}</label>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <label for="level" class="form-label fw-bold">IB Level</label>
                        <select name="level" id="level" class="form-select shadow-sm rounded-pill">
                            @foreach ($levels as $level)
                                <option value="{{ $level }}" {{ $ib->level == $level ? 'selected' : '' }}>Level {{ $level }}</option>
                            @endforeach
                        </select>
                        <div class="invalid-feedback">
                            Please select an IB level.
                        </div>
                    </div>
                </div>

                <div class="row g-3 mb-4">
                    <div class="col-md-6">
                        <label for="commission_rate" class="form-label fw-bold">Commission Rate (%)</label>
                        <input type="number" name="commission_rate" id="commission_rate" class="form-control shadow-sm rounded-pill" value="{{ old('commission_rate', $ib->commission_rate) }}" placeholder="Optional" min="0" step="0.01">
                        <div class="invalid-feedback">
                            Please provide a valid commission rate.
                        </div>
                    </div>

                    <div class="col-md-6">
                        <label for="country" class="form-label fw-bold">Country</label>
                        <input type="text" name="country" id="country" class="form-control shadow-sm rounded-pill" value="{{ old('country', $ib->country) }}" placeholder="Optional">
                        <div class="invalid-feedback">
                            Please provide a valid country name.
                        </div>
                    </div>
                </div>

                <!-- Add Upline Change Option -->
                <div class="row g-3 mb-4">
                    <div class="col-md-12">
                        <label for="upline_ib" class="form-label fw-bold">Change Upline IB <span class="text-danger">*</span></label>
                        <select name="upline_ib" id="upline_ib" class="form-select shadow-sm rounded-pill" required>
                            <option value="" disabled selected>Select Upline IB</option>
                            @foreach ($ibOptions as $uplineIb)
                                <option value="{{ $uplineIb->id }}" {{ $ib->parent_ib_id == $uplineIb->id ? 'selected' : '' }}>
                                    {{ $uplineIb->name }} ({{ $uplineIb->email }})
                                </option>
                            @endforeach
                        </select>
                        <div class="invalid-feedback">
                            Please select an upline IB.
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer text-end">
                <button type="submit" class="btn btn-success btn-lg shadow-sm rounded-pill"><i class="fas fa-save me-2"></i> Save Changes</button>
                <button type="reset" class="btn btn-outline-secondary btn-lg shadow-sm rounded-pill"><i class="fas fa-undo me-2"></i> Reset</button>
            </div>
        </div>
    </form>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Apply validation on form submit
        const form = document.querySelector('.needs-validation');
        form.addEventListener('submit', function (event) {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            form.classList.add('was-validated');
        });

        // Update the label for active status switch
        const isActiveToggle = document.getElementById('isActiveToggle');
        const statusLabel = document.getElementById('isActiveLabel');
        isActiveToggle.addEventListener('change', function () {
            statusLabel.textContent = isActiveToggle.checked ? 'Active' : 'Inactive';
        });
    });
</script>
@endsection