@extends('layouts.admin')

@section('title', 'Add New IB')

@section('content')
<div class="container mt-4">
    <h2 class="mb-4 text-center text-primary">
        <i class="fas fa-user-plus me-2"></i> Add New IB
    </h2>

    <div class="card shadow-sm">
        <div class="card-header bg-gradient-primary text-white">
            <strong>New IB Details</strong>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.ib.store') }}" method="POST">
                @csrf
                <div class="mb-3">
                    <label for="name" class="form-label">Name</label>
                    <input type="text" name="name" id="name" class="form-control" required>
                </div>
                <div class="mb-3">
                    <label for="email" class="form-label">Email</label>
                    <input type="email" name="email" id="email" class="form-control" required>
                </div>
                <div class="mb-3">
                    <label for="password" class="form-label">Password</label>
                    <input type="password" name="password" id="password" class="form-control" required>
                </div>
                <div class="mb-3">
                    <label for="password_confirmation" class="form-label">Confirm Password</label>
                    <input type="password" name="password_confirmation" id="password_confirmation" class="form-control" required>
                </div>
                <button type="submit" class="btn btn-primary"><i class="fas fa-save me-2"></i> Save</button>
                <a href="{{ route('admin.ib.management') }}" class="btn btn-secondary"><i class="fas fa-arrow-left me-2"></i> Back</a>
            </form>
        </div>
    </div>
</div>
@endsection
