@extends('layouts.admin')

@section('title', 'IB Tree')

@section('content')
<div class="container-fluid px-4">
    <div class="row mb-4">
        <div class="col-12 text-center">
            <h2 class="mt-4 text-primary fw-bold">
                <i class="fas fa-sitemap me-2"></i> IB Tree for {{ $ib->name }}
            </h2>
        </div>
    </div>

    <div class="card shadow-lg border-0 mb-5 rounded-4">
        <div class="card-header bg-gradient-primary text-white d-flex justify-content-between align-items-center rounded-top">
            <strong><i class="fas fa-network-wired me-2"></i> IB Tree Structure</strong>
            <a href="{{ route('admin.ib.management') }}" class="btn btn-light btn-sm shadow-sm rounded-pill">
                <i class="fas fa-arrow-left me-2"></i> Back to Management
            </a>
        </div>
        <div class="card-body text-center p-5">
            @if ($tree && count($tree) > 0)
                <div class="tree-container mt-4">
                    <ul class="tree">
                        <li>
                            <div class="tree-node" data-toggle="tooltip" data-tooltip="Email: {{ $ib->email }} | Level: 1">
                                <i class="fas fa-user-tie fa-lg mb-2 text-primary"></i>
                                <div class="node-content">
                                    <strong class="node-name">{{ $ib->name }}</strong>
                                    <div class="node-email small text-muted">{{ $ib->email }}</div>
                                    @if ($ib->is_active)
                                        <span class="badge bg-gradient-success text-light">Active</span>
                                    @else
                                        <span class="badge bg-gradient-danger text-light">Inactive</span>
                                    @endif
                                    <div class="node-actions mt-2">
                                        <a href="{{ route('admin.ib.tree', ['id' => $ib->id]) }}" class="btn btn-outline-primary btn-sm shadow-sm rounded-pill" title="Show Subtree">
                                            <i class="fas fa-sitemap"></i>
                                        </a>
                                        <a href="{{ route('admin.ib.edit', ['id' => $ib->id]) }}" class="btn btn-outline-secondary btn-sm shadow-sm rounded-pill" title="Edit IB">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            @if (!empty($tree))
                                @include('admin.partials.ib-tree-children', ['children' => $tree])
                            @endif
                        </li>
                    </ul>
                </div>
            @else
                <div class="alert alert-info text-center mt-3">
                    <i class="fas fa-info-circle me-2"></i> No IBs found in the tree.
                </div>
            @endif
        </div>
    </div>
</div>

<style>
    /* Tree Container Styling */
    .tree-container {
        display: flex;
        justify-content: center;
        align-items: center;
        overflow-x: auto;
        padding: 40px;
        background: linear-gradient(135deg, #d8e3f5, #f0f4ff);
        border-radius: 20px;
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
        animation: fadeIn 1.5s ease-in-out;
    }

    /* General Tree Styling */
    .tree {
        list-style-type: none;
        padding: 0;
        margin: 0 auto;
        position: relative;
        display: inline-block;
        white-space: nowrap;
        max-width: 100%;
    }

    .tree ul {
        padding-top: 40px;
        position: relative;
        padding-left: 0;
        transition: all 0.5s;
    }

    .tree li {
        list-style-type: none;
        text-align: center;
        position: relative;
        padding: 15px 5px 0 5px;
        display: inline-block;
        transition: all 0.5s;
        animation: slideInFromBottom 1s ease-in-out;
    }

    /* Connectors between nodes */
    .tree li::before, .tree li::after {
        content: '';
        position: absolute;
        top: 0;
        right: 50%;
        border-top: 2px solid #ccc;
        width: 50%;
        height: 20px;
        animation: growLine 1.5s ease-in-out;
    }

    .tree li::after {
        right: auto;
        left: 50%;
        border-left: 2px solid #ccc;
    }

    /* Hide connectors for only child nodes */
    .tree li:only-child::after, .tree li:only-child::before {
        display: none;
    }

    .tree li:only-child {
        padding-top: 0;
    }

    /* Horizontal lines between sibling nodes */
    .tree li:first-child::before, .tree li:last-child::after {
        border: 0 none;
    }

    .tree li:last-child::before {
        border-right: 2px solid #ccc;
        border-radius: 0 10px 0 0;
    }

    .tree li:first-child::after {
        border-radius: 10px 0 0 0;
    }

    /* Main node box styling */
    .tree-node {
        border: 2px solid #007bff;
        padding: 15px 20px;
        width: 150px; /* Consistent size for nodes */
        border-radius: 12px;
        display: inline-block;
        background: #ffffff;
        color: #333;
        text-align: center;
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
        transition: all 0.3s ease-in-out;
        position: relative;
        animation: popIn 1.2s ease-out;
        overflow: hidden;
    }

    /* Node content */
    .node-content {
        padding-top: 5px;
    }

    .node-name {
        font-size: 0.85rem;
        font-weight: bold;
    }

    .node-email {
        font-size: 0.75rem;
        margin-top: 3px;
    }

    .node-actions {
        margin-top: 5px;
        display: flex;
        justify-content: center;
        gap: 5px;
    }

    /* Hover effect on nodes */
    .tree-node:hover {
        transform: translateY(-8px) scale(1.08);
        cursor: pointer;
        box-shadow: 0 12px 25px rgba(0, 0, 0, 0.2);
        background: linear-gradient(145deg, #f5f5f5, #e4e4e4);
    }

    /* Node Badge Styling */
    .tree-node .badge {
        margin-top: 5px;
        display: inline-block;
        font-size: 0.7rem;
        padding: 4px 8px;
        border-radius: 5px;
    }

    /* Connecting lines to create branches */
    .tree ul::before {
        content: '';
        position: absolute;
        top: 0;
        left: 50%;
        border-left: 2px solid #ccc;
        width: 0;
        height: 20px;
    }

    /* Tooltip Styling */
    .tree-node[data-toggle="tooltip"]::after {
        content: attr(data-tooltip);
        position: absolute;
        left: 50%;
        bottom: calc(100% + 10px);
        transform: translateX(-50%);
        background: rgba(51, 51, 51, 0.9);
        color: #fff;
        padding: 6px 10px;
        border-radius: 5px;
        white-space: nowrap;
        font-size: 0.75rem;
        opacity: 0;
        pointer-events: none;
        transition: all 0.3s ease-in-out;
        box-shadow: 0px 2px 8px rgba(0, 0, 0, 0.2);
    }

    .tree-node:hover[data-toggle="tooltip"]::after {
        opacity: 1;
        pointer-events: auto;
    }

    /* Keyframes for animations */
    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }

    @keyframes slideInFromBottom {
        from { transform: translateY(50px); opacity: 0; }
        to { transform: translateY(0); opacity: 1; }
    }

    @keyframes growLine {
        from { height: 0; }
        to { height: 20px; }
    }

    @keyframes popIn {
        0% { transform: scale(0); opacity: 0; }
        100% { transform: scale(1); opacity: 1; }
    }

    /* Responsive Styles for Smaller Devices */
    @media (max-width: 768px) {
        .tree-node {
            padding: 10px 12px;
            font-size: 0.75rem;
            width: 100px;
        }

        .tree li {
            padding: 10px 5px 0 5px;
        }

        .tree ul {
            padding-top: 20px;
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Highlight the currently active node for better visibility
        const currentNode = document.querySelector('.tree-node');
        if (currentNode) {
            currentNode.classList.add('border-primary');
        }

        // Smooth scrolling effect for subtree links
        const subtreeLinks = document.querySelectorAll('.tree a.btn-outline-primary');
        subtreeLinks.forEach(link => {
            link.addEventListener('click', function (e) {
                e.preventDefault();
                const targetId = this.getAttribute('href');
                const targetElement = document.querySelector(targetId);
                if (targetElement) {
                    targetElement.scrollIntoView({ behavior: 'smooth' });
                }
            });
        });
    });
</script>
@endsection
