@extends('layouts.admin')

@section('title', 'Add New Commission Level')

@section('content')
<div class="container-fluid px-4">
    <h2 class="mt-4 mb-4 text-primary text-center fw-bold">
        <i class="fas fa-plus-circle me-2"></i> Add New Commission Level
    </h2>

    <div class="card shadow-lg border-0 mb-5 rounded-4">
        <div class="card-header bg-gradient-primary text-white rounded-top">
            <strong><i class="fas fa-cogs me-2"></i> Commission Level Details</strong>
        </div>
        <div class="card-body bg-light p-4">
            <form action="{{ route('admin.ib-commission-levels.store') }}" method="POST" class="needs-validation" novalidate>
                @csrf

                <div class="mb-3">
                    <label for="level" class="form-label fw-bold">Level <span class="text-danger">*</span></label>
                    <input type="number" name="level" id="level" class="form-control shadow-sm rounded-pill" value="{{ old('level') }}" required>
                    <div class="invalid-feedback">
                        Please provide the commission level.
                    </div>
                </div>

                <div class="mb-3">
                    <label for="commission_percentage" class="form-label fw-bold">Commission Percentage (%) <span class="text-danger">*</span></label>
                    <input type="number" name="commission_percentage" id="commission_percentage" class="form-control shadow-sm rounded-pill" value="{{ old('commission_percentage') }}" required min="0" max="100" step="0.01">
                    <div class="invalid-feedback">
                        Please provide a valid commission percentage (0-100).
                    </div>
                </div>

                <button type="submit" class="btn btn-success shadow-sm rounded-pill"><i class="fas fa-save me-2"></i> Save Level</button>
                <a href="{{ route('admin.ib-commission-levels.index') }}" class="btn btn-outline-secondary shadow-sm rounded-pill"><i class="fas fa-arrow-left me-2"></i> Cancel</a>
            </form>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const form = document.querySelector('.needs-validation');
        form.addEventListener('submit', function (event) {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            form.classList.add('was-validated');
        });
    });
</script>
@endsection
