@extends('layouts.admin')

@section('title', 'Email Settings')

@section('content')
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mt-4 mb-4">
        <h1 class="h3 fw-bold text-primary">
            <i class="fas fa-envelope me-2"></i> Email Settings
        </h1>
    </div>

    <!-- Email Settings Form -->
    <div class="card shadow-lg border-0 mb-5">
        <div class="card-header bg-gradient-primary text-white d-flex align-items-center">
            <h4 class="mb-0"><i class="fas fa-cogs me-2"></i> Configure SMTP Settings</h4>
        </div>
        <div class="card-body p-4">
            <form action="{{ route('admin.email-settings.update') }}" method="POST" class="email-settings-form bg-white p-5 rounded shadow-sm border border-light">
                @csrf
                @method('PUT')

                <div class="mb-4">
                    <label class="form-label fw-semibold">SMTP Host</label>
                    <input type="text" name="smtp_host" value="{{ $emailSettings->smtp_host ?? '' }}" class="form-control form-control-lg" required>
                </div>

                <div class="mb-4">
                    <label class="form-label fw-semibold">SMTP Port</label>
                    <input type="number" name="smtp_port" value="{{ $emailSettings->smtp_port ?? '' }}" class="form-control form-control-lg" required>
                </div>

                <div class="mb-4">
                    <label class="form-label fw-semibold">SMTP Username</label>
                    <input type="text" name="smtp_username" value="{{ $emailSettings->smtp_username ?? '' }}" class="form-control form-control-lg" required>
                </div>

                <div class="mb-4">
                    <label class="form-label fw-semibold">SMTP Password</label>
                    <input type="password" name="smtp_password" value="{{ $emailSettings->smtp_password ?? '' }}" class="form-control form-control-lg" required>
                </div>

                <div class="mb-4">
                    <label class="form-label fw-semibold">SMTP Encryption</label>
                    <select name="smtp_encryption" class="form-select form-select-lg">
                        <option value="">None</option>
                        <option value="tls" {{ isset($emailSettings) && $emailSettings->smtp_encryption == 'tls' ? 'selected' : '' }}>TLS</option>
                        <option value="ssl" {{ isset($emailSettings) && $emailSettings->smtp_encryption == 'ssl' ? 'selected' : '' }}>SSL</option>
                    </select>
                </div>

                <div class="mb-4">
                    <label class="form-label fw-semibold">From Email</label>
                    <input type="email" name="from_email" value="{{ $emailSettings->from_email ?? '' }}" class="form-control form-control-lg" required>
                </div>

                <div class="mb-4">
                    <label class="form-label fw-semibold">From Name</label>
                    <input type="text" name="from_name" value="{{ $emailSettings->from_name ?? '' }}" class="form-control form-control-lg" required>
                </div>

                <div class="text-end">
                    <button type="submit" class="btn btn-gradient-primary btn-lg shadow">
                        <i class="fas fa-save"></i> Save Settings
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
