@extends('layouts.admin')

@section('title', 'Admin Activity Logs')

@section('content')
<div class="container-fluid">
    <h2 class="mt-4">Activity Logs</h2>

    @if($logs->isNotEmpty())
        <table class="table table-hover mt-3">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>User</th>
                    <th>Action</th>
                    <th>IP Address</th>
                    <th>Created At</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($logs as $log)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $log->user->name }}</td>
                        <td>{{ $log->action }}</td>
                        <td>{{ $log->ip_address }}</td>
                        <td>{{ $log->created_at->format('d-m-Y H:i:s') }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
        {{ $logs->links() }}
    @else
        <p class="mt-4">No activity logs available.</p>
    @endif
</div>
@endsection
