import './bootstrap';
import Alpine from 'alpinejs';
import Chart from 'chart.js/auto';

window.Alpine = Alpine;

Alpine.start();

// Function to initialize the trading line chart
function initializeTradingChart(dataLabels, dataValues) {
    const tradingChartCanvas = document.getElementById('tradingChart');
    if (tradingChartCanvas) {
        new Chart(tradingChartCanvas.getContext('2d'), {
            type: 'line',
            data: {
                labels: dataLabels, // Dynamic labels
                datasets: [
                    {
                        label: 'Monthly Profit/Loss',
                        data: dataValues, // Dynamic data
                        borderColor: 'rgba(75, 192, 192, 1)',
                        backgroundColor: 'rgba(75, 192, 192, 0.2)',
                        tension: 0.4,
                        fill: true,
                    },
                ],
            },
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        display: true,
                        position: 'top',
                    },
                },
                scales: {
                    x: {
                        grid: { display: false },
                    },
                    y: {
                        beginAtZero: true,
                        grid: { color: '#e5e5e5' },
                    },
                },
            },
        });
    }
}

// Function to initialize the dashboard doughnut chart
function initializeDashboardChart(dataLabels, dataValues, colors) {
    const dashboardChartCanvas = document.getElementById('dashboardChart');
    if (dashboardChartCanvas) {
        new Chart(dashboardChartCanvas.getContext('2d'), {
            type: 'doughnut',
            data: {
                labels: dataLabels, // Dynamic labels
                datasets: [
                    {
                        label: 'Transactions',
                        data: dataValues, // Dynamic data
                        backgroundColor: colors, // Dynamic colors
                    },
                ],
            },
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        display: true,
                        position: 'top',
                    },
                },
            },
        });
    }
}

// DOMContentLoaded to ensure the DOM is fully loaded before initializing charts
document.addEventListener('DOMContentLoaded', function () {
    // Fetch or use predefined data for charts
    const tradingLabels = JSON.parse(document.getElementById('tradingLabels').value || '[]');
    const tradingData = JSON.parse(document.getElementById('tradingData').value || '[]');
    initializeTradingChart(tradingLabels, tradingData);

    const dashboardLabels = JSON.parse(document.getElementById('dashboardLabels').value || '[]');
    const dashboardData = JSON.parse(document.getElementById('dashboardData').value || '[]');
    const dashboardColors = ['#4caf50', '#fbc02d', '#e53935']; // Example colors
    initializeDashboardChart(dashboardLabels, dashboardData, dashboardColors);
});
