<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Role;

class MigrateUserRolesSeeder extends Seeder
{
    public function run()
    {
        foreach (User::all() as $user) {
            $role = Role::where('name', $user->role)->first();
            if ($role) {
                $user->roles()->syncWithoutDetaching([$role->id]);
            }
        }
    }
}
