<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Default Export Driver
    |--------------------------------------------------------------------------
    |
    | Here you may specify the default export driver. Supported drivers are
    | "xlsx", "csv", "ods", "xls". You can also create your own driver
    | implementation.
    |
    */

    'default' => 'xlsx',

    /*
    |--------------------------------------------------------------------------
    | Excel Writer
    |--------------------------------------------------------------------------
    |
    | You can specify the default Excel writer that will be used when exporting
    | data. The default is "Xlsx" but you can set it to any of the available
    | writers: Xlsx, Csv, Ods, Xls, etc.
    |
    */

    'writer_type' => 'Xlsx',

    /*
    |--------------------------------------------------------------------------
    | Exports & Imports
    |--------------------------------------------------------------------------
    |
    | You can define your export & import settings here. By default, a few common
    | settings are already set for you, such as the delimiter for CSV exports.
    |
    */

    'exports' => [
        'chunk_size' => 1000,
        'force_sheets_collection' => false,
        'write_only' => false,
        'disk' => null,
    ],

    'imports' => [
        'chunk_size' => 1000,
        'force_sheets_collection' => false,
        'write_only' => false,
        'disk' => null,
    ],

    /*
    |--------------------------------------------------------------------------
    | CSV Settings
    |--------------------------------------------------------------------------
    |
    | You can define CSV export settings here, such as the delimiter and enclosure.
    |
    */

    'csv' => [
        'delimiter' => ',',
        'enclosure' => '"',
        'line_ending' => "\r\n",
    ],

    /*
    |--------------------------------------------------------------------------
    | Excel Data Format
    |--------------------------------------------------------------------------
    |
    | This setting defines the date format used for Excel exports. By default,
    | the format will be "Y-m-d H:i:s", but you can change it as per your needs.
    |
    */

    'excel_date_format' => 'Y-m-d H:i:s',

    /*
    |--------------------------------------------------------------------------
    | Custom Export
    |--------------------------------------------------------------------------
    |
    | If you need to define custom export logic for your own classes, you can
    | define your custom logic here. The export logic could be applied when
    | exporting data to a CSV, XLSX, or any other format.
    |
    */

    'export' => [
        'headings' => true,
    ],

    /*
    |--------------------------------------------------------------------------
    | Use custom Excel Extension
    |--------------------------------------------------------------------------
    |
    | If you are using an extension of Excel (e.g. "Laravel Excel" or "PhpSpreadsheet"),
    | you can customize this if required.
    |
    */

    'custom_excel_extension' => null,

    /*
    |--------------------------------------------------------------------------
    | Mapping custom classes
    |--------------------------------------------------------------------------
    |
    | You can map custom classes (e.g. imports and exports) here to apply special
    | processing or formats during export or import.
    |
    */

    'mapping' => [],
];
