<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AdminMT5APISettingsController extends Controller
{
    /**
     * Display the MT5 API Settings page.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        // Fetch all MT5 API settings from the database
        $settings = DB::table('mt5_api_settings')->get();

        return view('admin.mt5_api_setting', compact('settings'));
    }

    /**
     * Update MT5 API settings.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(Request $request)
    {
        // Validate the incoming request
        $request->validate([
            'server_type' => 'required|in:real,demo',
            'api_url' => 'required|url',
            'api_key' => 'required|string|max:255',
        ]);

        // Insert or update the MT5 API settings based on the server type
        DB::table('mt5_api_settings')->updateOrInsert(
            ['server_type' => $request->server_type], // Match on server_type
            [
                'api_url' => $request->api_url,
                'api_key' => $request->api_key,
                'updated_at' => now(),
            ]
        );

        // Redirect back with a success message
        return redirect()->route('admin.mt5.api.setting')->with('success', 'MT5 API settings updated successfully.');
    }
}
